/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.template.etl.api.realtime;

import co.cask.cdap.api.annotation.Beta;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;

@Beta
public class SourceState {
    private final Map<String, byte[]> stateMap;

    public SourceState(Map<String, byte[]> stateMap) {
        this.stateMap = Maps.newHashMap(stateMap);
    }

    public SourceState() {
        this.stateMap = Maps.newHashMap();
    }

    public SourceState(SourceState state) {
        this(state.getState());
    }

    public byte[] getState(String state) {
        return this.stateMap.get(state);
    }

    public void setState(String state, byte[] value) {
        this.stateMap.put(state, value);
    }

    public Map<String, byte[]> getState() {
        return Maps.newHashMap(this.stateMap);
    }

    public void setState(Map<String, byte[]> map) {
        this.stateMap.putAll(map);
    }

    public void setState(SourceState state) {
        this.clearState();
        this.setState(state.getState());
    }

    public void clearState() {
        this.stateMap.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceState that = (SourceState)o;
        return Objects.equals(this.stateMap, that.stateMap);
    }

    public int hashCode() {
        return Objects.hash(this.stateMap);
    }
}

