/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.template.etl.realtime;

import co.cask.cdap.api.app.ApplicationConfigurer;
import co.cask.cdap.api.app.ApplicationContext;
import co.cask.cdap.api.dataset.DatasetProperties;
import co.cask.cdap.api.dataset.lib.KeyValueTable;
import co.cask.cdap.api.templates.AdapterConfigurer;
import co.cask.cdap.api.worker.Worker;
import co.cask.cdap.template.etl.common.ETLConfig;
import co.cask.cdap.template.etl.common.ETLTemplate;
import co.cask.cdap.template.etl.realtime.ETLWorker;
import co.cask.cdap.template.etl.realtime.config.ETLRealtimeConfig;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ETLRealtimeTemplate
extends ETLTemplate<ETLRealtimeConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(ETLRealtimeTemplate.class);
    public static final String STATE_TABLE = "etlrealtimesourcestate";
    private static final Gson GSON = new Gson();

    public void configureAdapter(String adapterName, ETLRealtimeConfig etlConfig, AdapterConfigurer configurer) throws Exception {
        super.configureAdapter(adapterName, (ETLConfig)etlConfig, configurer);
        int instances = etlConfig.getInstances() != null ? etlConfig.getInstances() : 1;
        Preconditions.checkArgument((instances > 0 ? 1 : 0) != 0, (Object)"Instances should be greater than 0");
        configurer.addRuntimeArgument("config", GSON.toJson((Object)etlConfig));
        configurer.setInstances(instances);
        configurer.addRuntimeArgument("uniqueid", String.valueOf(System.currentTimeMillis()));
    }

    public void configure(ApplicationConfigurer configurer, ApplicationContext context) {
        configurer.setName(this.getAppName("etl.realtime.plugin.name"));
        configurer.setDescription("Realtime Extract-Transform-Load (ETL) Template");
        configurer.addWorker((Worker)new ETLWorker());
        configurer.createDataset(STATE_TABLE, KeyValueTable.class, DatasetProperties.EMPTY);
    }
}

