/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.proto.v2;

import co.cask.cdap.etl.proto.ArtifactSelectorConfig;
import co.cask.cdap.etl.proto.UpgradeContext;
import co.cask.cdap.etl.proto.v2.ETLPlugin;
import java.util.Objects;

public final class ETLStage {
    private final String name;
    private final ETLPlugin plugin;
    private final String errorDatasetName;

    public ETLStage(String name, ETLPlugin plugin) {
        this.name = name;
        this.plugin = plugin;
        this.errorDatasetName = null;
    }

    public String getName() {
        return this.name;
    }

    public ETLPlugin getPlugin() {
        return this.plugin;
    }

    public void validate() {
        if (this.name == null || this.name.isEmpty()) {
            throw new IllegalArgumentException(String.format("Invalid stage '%s': name must be specified.", this.toString()));
        }
        if (this.plugin == null) {
            throw new IllegalArgumentException(String.format("Invalid stage '%s': plugin must be specified.", this.name));
        }
        if (this.errorDatasetName != null) {
            throw new IllegalArgumentException(String.format("Invalid stage '%s'. Error datasets have been replaced by error collectors. Please connect stage '%s' to an error collector, then connect the error collector to a sink.", this.name, this.name));
        }
        this.plugin.validate();
    }

    public ETLStage upgradeStage(UpgradeContext upgradeContext) {
        ArtifactSelectorConfig artifactSelectorConfig = upgradeContext.getPluginArtifact(this.plugin.getType(), this.plugin.getName());
        ETLPlugin etlPlugin = new ETLPlugin(this.plugin.getName(), this.plugin.getType(), this.plugin.getProperties(), artifactSelectorConfig);
        return new ETLStage(this.name, etlPlugin);
    }

    public String toString() {
        return "ETLStage{name='" + this.name + '\'' + ", plugin=" + this.plugin + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ETLStage that = (ETLStage)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.plugin, that.plugin);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.plugin);
    }
}

