/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.proto.v2;

import co.cask.cdap.api.Resources;
import co.cask.cdap.etl.api.Engine;
import co.cask.cdap.etl.proto.Connection;
import co.cask.cdap.etl.proto.v2.ETLConfig;
import co.cask.cdap.etl.proto.v2.ETLStage;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public final class ETLBatchConfig
extends ETLConfig {
    private final Engine engine;
    private final String schedule;
    private final Integer maxConcurrentRuns;
    private final List<ETLStage> postActions;
    private final List<ETLStage> actions;

    private ETLBatchConfig(Set<ETLStage> stages, Set<Connection> connections, List<ETLStage> postActions, Resources resources, boolean stageLoggingEnabled, boolean processTimingEnabled, Engine engine, String schedule, Resources driverResources, Resources clientResources, int numOfRecordsPreview, @Nullable Integer maxConcurrentRuns, Map<String, String> engineProperties) {
        super(stages, connections, resources, driverResources, clientResources, stageLoggingEnabled, processTimingEnabled, numOfRecordsPreview, engineProperties);
        this.postActions = ImmutableList.copyOf(postActions);
        this.engine = engine;
        this.schedule = schedule;
        this.maxConcurrentRuns = maxConcurrentRuns;
        this.actions = null;
    }

    public ETLBatchConfig convertOldConfig() {
        if (!this.getStages().isEmpty()) {
            return this;
        }
        Builder builder = ETLBatchConfig.builder(this.schedule).setEngine(this.engine).setDriverResources(this.getDriverResources()).addPostActions(this.actions == null ? new HashSet() : this.actions);
        return this.convertStages(builder, "batchsource", "batchsink").build();
    }

    public List<ETLStage> getPostActions() {
        return Collections.unmodifiableList(this.postActions == null ? new ArrayList() : this.postActions);
    }

    public Engine getEngine() {
        return this.engine == null ? Engine.MAPREDUCE : this.engine;
    }

    @Nullable
    public String getSchedule() {
        return this.schedule;
    }

    @Nullable
    public Integer getMaxConcurrentRuns() {
        return this.maxConcurrentRuns;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ETLBatchConfig that = (ETLBatchConfig)o;
        return Objects.equals(this.engine, that.engine) && Objects.equals(this.schedule, that.schedule) && Objects.equals(this.postActions, that.postActions) && Objects.equals(this.actions, that.actions) && Objects.equals(this.maxConcurrentRuns, that.maxConcurrentRuns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.engine, this.schedule, this.postActions, this.actions, this.maxConcurrentRuns);
    }

    @Override
    public String toString() {
        return "ETLBatchConfig{engine=" + this.engine + ", schedule='" + this.schedule + '\'' + ", maxConcurrentRuns=" + this.maxConcurrentRuns + ", postActions=" + this.postActions + ", actions=" + this.actions + "} " + super.toString();
    }

    @Deprecated
    public static Builder builder(String schedule) {
        return new Builder(schedule);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ETLConfig.Builder<Builder> {
        private String schedule;
        private Engine engine;
        private List<ETLStage> endingActions;
        private Integer maxConcurrentRuns;

        private Builder() {
            this((String)null);
        }

        @Deprecated
        public Builder(String schedule) {
            this.schedule = schedule;
            this.engine = Engine.MAPREDUCE;
            this.endingActions = new ArrayList<ETLStage>();
        }

        public Builder setTimeSchedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public Builder setEngine(Engine engine) {
            this.engine = engine;
            return this;
        }

        @Override
        public Builder setDriverResources(Resources driverResources) {
            this.driverResources = driverResources;
            return this;
        }

        public Builder addPostAction(ETLStage action) {
            this.endingActions.add(action);
            return this;
        }

        public Builder addPostActions(Collection<ETLStage> actions) {
            this.endingActions.addAll(actions);
            return this;
        }

        public Builder setMaxConcurrentRuns(int maxConcurrentRuns) {
            this.maxConcurrentRuns = maxConcurrentRuns;
            return this;
        }

        public ETLBatchConfig build() {
            return new ETLBatchConfig(this.stages, this.connections, this.endingActions, this.resources, this.stageLoggingEnabled, this.processTimingEnabled, this.engine, this.schedule, this.driverResources, this.clientResources, this.numOfRecordsPreview, this.maxConcurrentRuns, this.properties);
        }
    }
}

