/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.proto.v1;

import co.cask.cdap.etl.proto.ArtifactSelectorConfig;
import co.cask.cdap.etl.proto.UpgradeContext;
import co.cask.cdap.etl.proto.v1.Plugin;
import co.cask.cdap.etl.proto.v2.ETLPlugin;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ETLStage {
    private final String name;
    private final Plugin plugin;
    private final Map<String, String> properties;
    private final String errorDatasetName;

    public ETLStage(String name, Plugin plugin, @Nullable String errorDatasetName) {
        this.name = name;
        this.plugin = plugin;
        this.properties = plugin.getProperties();
        this.errorDatasetName = errorDatasetName;
    }

    public ETLStage(String name, Plugin plugin) {
        this(name, plugin, null);
    }

    public ETLStage getCompatibleStage(String stageName) {
        if (this.plugin != null) {
            return this;
        }
        return new ETLStage(stageName, new Plugin(this.name, this.properties), this.errorDatasetName);
    }

    public String getName() {
        return this.name;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public String toString() {
        return "ETLStage{name='" + this.name + '\'' + ", plugin=" + this.plugin + ", errorDatasetName='" + this.errorDatasetName + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ETLStage that = (ETLStage)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.plugin, that.plugin) && Objects.equals(this.errorDatasetName, that.errorDatasetName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.plugin, this.errorDatasetName);
    }

    public co.cask.cdap.etl.proto.v2.ETLStage upgradeStage(String type, UpgradeContext upgradeContext) {
        ArtifactSelectorConfig artifactSelectorConfig = upgradeContext.getPluginArtifact(type, this.plugin.getName());
        if (artifactSelectorConfig == null) {
            artifactSelectorConfig = this.plugin.getArtifact();
        }
        ETLPlugin etlPlugin = new ETLPlugin(this.plugin.getName(), type, this.plugin.getProperties(), artifactSelectorConfig);
        if (this.errorDatasetName != null) {
            throw new IllegalStateException(String.format("Cannot upgrade stage '%s'. Error datasets have been replaced by error collectors. Please connect stage '%s' to an error collector, then connect the error collector to a sink.", this.name, this.name));
        }
        return new co.cask.cdap.etl.proto.v2.ETLStage(this.name, etlPlugin);
    }
}

