/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.proto.v1;

import co.cask.cdap.api.Resources;
import co.cask.cdap.etl.proto.Connection;
import co.cask.cdap.etl.proto.UpgradeContext;
import co.cask.cdap.etl.proto.UpgradeableConfig;
import co.cask.cdap.etl.proto.v1.ETLConfig;
import co.cask.cdap.etl.proto.v1.ETLStage;
import co.cask.cdap.etl.proto.v2.ETLBatchConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class ETLBatchConfig
extends ETLConfig
implements UpgradeableConfig<co.cask.cdap.etl.proto.v2.ETLBatchConfig> {
    private final Engine engine;
    private final String schedule;
    private final List<ETLStage> actions;
    private final Resources driverResources;

    private ETLBatchConfig(Engine engine, String schedule, ETLStage source, List<ETLStage> sinks, List<ETLStage> transforms, List<Connection> connections, Resources resources, Resources driverResources, List<ETLStage> actions) {
        super(source, sinks, transforms, connections, resources, true);
        this.engine = engine;
        this.schedule = schedule;
        this.actions = actions;
        this.driverResources = driverResources;
    }

    public Engine getEngine() {
        return this.engine == null ? Engine.MAPREDUCE : this.engine;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public List<ETLStage> getActions() {
        return this.actions;
    }

    public Resources getDriverResources() {
        return this.driverResources;
    }

    @Override
    public boolean canUpgrade() {
        return true;
    }

    @Override
    public co.cask.cdap.etl.proto.v2.ETLBatchConfig upgrade(UpgradeContext upgradeContext) {
        ETLBatchConfig.Builder builder = co.cask.cdap.etl.proto.v2.ETLBatchConfig.builder(this.schedule).setEngine(co.cask.cdap.etl.api.Engine.valueOf((String)this.getEngine().name())).setDriverResources(this.getDriverResources());
        return this.upgradeBase(builder, upgradeContext, "batchsource", "batchsink").build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ETLBatchConfig that = (ETLBatchConfig)o;
        return Objects.equals(this.schedule, that.schedule) && Objects.equals(this.actions, that.actions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.schedule, this.actions);
    }

    @Override
    public String toString() {
        return "ETLBatchConfig{engine=" + (Object)((Object)this.engine) + ", schedule='" + this.schedule + '\'' + ", actions=" + this.actions + ", driverResources=" + this.driverResources + "} " + super.toString();
    }

    public static Builder builder(String schedule) {
        return new Builder(schedule);
    }

    public static class Builder
    extends ETLConfig.Builder<Builder> {
        private final String schedule;
        private Engine engine;
        private List<ETLStage> actions;
        private Resources driverResources;

        public Builder(String schedule) {
            this.schedule = schedule;
            this.actions = new ArrayList<ETLStage>();
            this.engine = Engine.MAPREDUCE;
        }

        public Builder addAction(ETLStage action) {
            this.actions.add(action);
            return this;
        }

        public Builder addActions(Collection<ETLStage> actions) {
            this.actions.addAll(actions);
            return this;
        }

        public Builder setEngine(Engine engine) {
            this.engine = engine;
            return this;
        }

        public Builder setDriverResources(Resources driverResources) {
            this.driverResources = driverResources;
            return this;
        }

        public ETLBatchConfig build() {
            return new ETLBatchConfig(this.engine, this.schedule, this.source, this.sinks, this.transforms, this.connections, this.resources, this.driverResources, this.actions);
        }
    }

    public static enum Engine {
        MAPREDUCE,
        SPARK;

    }
}

