/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.proto;

import java.util.Objects;
import javax.annotation.Nullable;

public class Connection {
    private final String from;
    private final String to;
    private final String port;
    private final Boolean condition;

    public Connection(String from, String to) {
        this(from, to, null, null);
    }

    public Connection(String from, String to, @Nullable String port) {
        this(from, to, port, null);
    }

    public Connection(String from, String to, @Nullable Boolean condition) {
        this(from, to, null, condition);
    }

    private Connection(String from, String to, @Nullable String port, @Nullable Boolean condition) {
        this.from = from;
        this.to = to;
        this.port = port;
        this.condition = condition;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    @Nullable
    public String getPort() {
        return this.port;
    }

    @Nullable
    public Boolean getCondition() {
        return this.condition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Connection that = (Connection)o;
        return Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to) && Objects.equals(this.port, that.port) && Objects.equals(this.condition, that.condition);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to, this.port, this.condition);
    }

    public String toString() {
        return "Connection{from='" + this.from + '\'' + ", to='" + this.to + '\'' + ", port='" + this.port + '\'' + ", condition='" + this.condition + '\'' + '}';
    }
}

