/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.proto.v2;

import co.cask.cdap.api.Resources;
import co.cask.cdap.etl.proto.Connection;
import co.cask.cdap.etl.proto.v2.ETLConfig;
import co.cask.cdap.etl.proto.v2.ETLStage;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class ETLRealtimeConfig
extends ETLConfig {
    private final Integer instances;

    private ETLRealtimeConfig(Set<ETLStage> stages, Set<Connection> connections, Resources resources, boolean stageLoggingEnabled, boolean processTimingEnabled, int instances, int numOfRecordsPreview, Map<String, String> properties) {
        super(stages, connections, resources, resources, resources, stageLoggingEnabled, processTimingEnabled, numOfRecordsPreview, properties);
        this.instances = instances;
    }

    public ETLRealtimeConfig convertOldConfig() {
        if (!this.getStages().isEmpty()) {
            return this;
        }
        Builder builder = ETLRealtimeConfig.builder().setInstances(this.getInstances());
        return this.convertStages(builder, "realtimesource", "realtimesink").build();
    }

    public int getInstances() {
        return this.instances == null ? 1 : this.instances;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ETLRealtimeConfig that = (ETLRealtimeConfig)o;
        return Objects.equals(this.instances, that.instances);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.instances);
    }

    @Override
    public String toString() {
        return "ETLRealtimeConfig{instances=" + this.instances + "} " + super.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ETLConfig.Builder<Builder> {
        private int instances = 1;

        public Builder setInstances(int instances) {
            this.instances = instances;
            return this;
        }

        public ETLRealtimeConfig build() {
            return new ETLRealtimeConfig(this.stages, this.connections, this.resources, this.stageLoggingEnabled, this.processTimingEnabled, this.instances, this.numOfRecordsPreview, this.properties);
        }
    }
}

