/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.proto.v1;

import co.cask.cdap.api.Config;
import co.cask.cdap.api.Resources;
import co.cask.cdap.etl.proto.Connection;
import co.cask.cdap.etl.proto.UpgradeContext;
import co.cask.cdap.etl.proto.v1.ETLStage;
import co.cask.cdap.etl.proto.v2.ETLConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ETLConfig
extends Config {
    private Boolean stageLoggingEnabled;
    private final ETLStage source;
    private final List<ETLStage> sinks;
    private final List<ETLStage> transforms;
    private final List<Connection> connections;
    private final Resources resources;

    @Deprecated
    public ETLConfig(ETLStage source, List<ETLStage> sinks, List<ETLStage> transforms, List<Connection> connections, Resources resources) {
        this(source, sinks, transforms, connections, resources, true);
    }

    protected ETLConfig(ETLStage source, List<ETLStage> sinks, List<ETLStage> transforms, List<Connection> connections, Resources resources, boolean stageLoggingEnabled) {
        this.source = source;
        this.sinks = sinks;
        this.transforms = transforms;
        this.connections = this.getValidConnections(connections);
        this.resources = resources;
        this.stageLoggingEnabled = stageLoggingEnabled;
    }

    private List<Connection> getValidConnections(List<Connection> connections) {
        if (this.source.getPlugin() == null) {
            return new ArrayList<Connection>();
        }
        if (connections == null) {
            connections = new ArrayList<Connection>();
        }
        if (connections.isEmpty()) {
            String toSink = this.source.getName();
            if (this.transforms != null && !this.transforms.isEmpty()) {
                connections.add(new Connection(this.source.getName(), this.transforms.get(0).getName()));
                for (int i = 0; i < this.transforms.size() - 1; ++i) {
                    connections.add(new Connection(this.transforms.get(i).getName(), this.transforms.get(i + 1).getName()));
                }
                toSink = this.transforms.get(this.transforms.size() - 1).getName();
            }
            for (ETLStage stage : this.sinks) {
                connections.add(new Connection(toSink, stage.getName()));
            }
        }
        return connections;
    }

    public ETLConfig(ETLStage source, ETLStage sink, List<ETLStage> transforms, List<Connection> connections, Resources resources) {
        this(source, (List<ETLStage>)ImmutableList.of((Object)sink), transforms, connections, resources);
    }

    public ETLConfig getCompatibleConfig() {
        int pluginNum = 1;
        ETLStage sourceStage = this.source.getCompatibleStage("source." + this.source.getName() + "." + pluginNum);
        ArrayList<ETLStage> transformStages = new ArrayList<ETLStage>();
        if (this.transforms != null) {
            for (ETLStage transform : this.transforms) {
                transformStages.add(transform.getCompatibleStage("transform." + transform.getName() + "." + ++pluginNum));
            }
        }
        ArrayList<ETLStage> sinkStages = new ArrayList<ETLStage>();
        for (ETLStage sink : this.sinks) {
            sinkStages.add(sink.getCompatibleStage("sink." + sink.getName() + "." + ++pluginNum));
        }
        ArrayList<Connection> connectionList = this.connections == null ? new ArrayList() : this.connections;
        return new ETLConfig(sourceStage, sinkStages, transformStages, connectionList, this.resources);
    }

    public ETLStage getSource() {
        return this.source;
    }

    public List<ETLStage> getSinks() {
        return this.sinks == null ? new ArrayList() : this.sinks;
    }

    public List<ETLStage> getTransforms() {
        return this.transforms != null ? this.transforms : Lists.newArrayList();
    }

    public List<Connection> getConnections() {
        return this.connections == null ? new ArrayList() : this.connections;
    }

    public Resources getResources() {
        return this.resources == null ? new Resources() : this.resources;
    }

    public Boolean isStageLoggingEnabled() {
        return this.stageLoggingEnabled == null ? true : this.stageLoggingEnabled;
    }

    protected <T extends ETLConfig.Builder> T upgradeBase(T builder, UpgradeContext upgradeContext, String sourceType, String sinkType) {
        ((ETLConfig.Builder)builder.setResources(this.getResources())).addConnections(this.getConnections());
        if (!this.isStageLoggingEnabled().booleanValue()) {
            builder.disableStageLogging();
        }
        builder.addStage(this.getSource().upgradeStage(sourceType, upgradeContext));
        for (ETLStage transformStage : this.getTransforms()) {
            builder.addStage(transformStage.upgradeStage("transform", upgradeContext));
        }
        for (ETLStage sinkStage : this.getSinks()) {
            builder.addStage(sinkStage.upgradeStage(sinkType, upgradeContext));
        }
        return builder;
    }

    public String toString() {
        return "ETLConfig{stageLoggingEnabled=" + this.stageLoggingEnabled + ", source=" + this.source + ", sinks=" + this.sinks + ", transforms=" + this.transforms + ", connections=" + this.connections + ", resources=" + this.resources + "} " + super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ETLConfig that = (ETLConfig)((Object)o);
        return Objects.equals(this.source, that.source) && Objects.equals(this.sinks, that.sinks) && Objects.equals(this.transforms, that.transforms) && Objects.equals(this.connections, that.connections) && Objects.equals(this.resources, that.resources) && this.isStageLoggingEnabled() == that.isStageLoggingEnabled();
    }

    public int hashCode() {
        return Objects.hash(this.source, this.sinks, this.transforms, this.connections, this.resources, this.isStageLoggingEnabled());
    }

    public static abstract class Builder<T extends Builder> {
        protected ETLStage source;
        protected List<ETLStage> sinks = new ArrayList<ETLStage>();
        protected List<ETLStage> transforms = new ArrayList<ETLStage>();
        protected List<Connection> connections = new ArrayList<Connection>();
        protected Resources resources = new Resources();
        protected Boolean stageLoggingEnabled = true;

        protected Builder() {
        }

        public T setSource(ETLStage source) {
            this.source = source;
            return (T)this;
        }

        public T addTransform(ETLStage transform) {
            this.transforms.add(transform);
            return (T)this;
        }

        public T addTransforms(Collection<ETLStage> transforms) {
            this.transforms.addAll(transforms);
            return (T)this;
        }

        public T addSink(ETLStage sink) {
            this.sinks.add(sink);
            return (T)this;
        }

        public T addSinks(Collection<ETLStage> sinks) {
            this.sinks.addAll(sinks);
            return (T)this;
        }

        public T addConnection(String from, String to) {
            this.connections.add(new Connection(from, to));
            return (T)this;
        }

        public T addConnection(Connection connection) {
            this.connections.add(connection);
            return (T)this;
        }

        public T addConnections(Collection<Connection> connections) {
            this.connections.addAll(connections);
            return (T)this;
        }

        public T setResources(Resources resources) {
            this.resources = resources;
            return (T)this;
        }

        public T disableStageLogging() {
            this.stageLoggingEnabled = false;
            return (T)this;
        }
    }
}

