/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.proto.v2;

import co.cask.cdap.etl.proto.ArtifactSelectorConfig;
import co.cask.cdap.etl.proto.UpgradeContext;
import co.cask.cdap.etl.proto.v2.ETLPlugin;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ETLStage {
    private final String name;
    private final ETLPlugin plugin;
    private final String errorDatasetName;

    public ETLStage(String name, ETLPlugin plugin, @Nullable String errorDatasetName) {
        this.name = name;
        this.plugin = plugin;
        this.errorDatasetName = errorDatasetName;
    }

    public ETLStage(String name, ETLPlugin plugin) {
        this(name, plugin, null);
    }

    public String getName() {
        return this.name;
    }

    public ETLPlugin getPlugin() {
        return this.plugin;
    }

    @Nullable
    public String getErrorDatasetName() {
        return this.errorDatasetName;
    }

    public void validate() {
        if (this.name == null || this.name.isEmpty()) {
            throw new IllegalArgumentException("Invalid stage " + this.toString() + ": name must be specified.");
        }
        if (this.plugin == null) {
            throw new IllegalArgumentException("Invalid stage " + this.toString() + ": plugin must be specified.");
        }
        this.plugin.validate();
    }

    public ETLStage upgradeStage(UpgradeContext upgradeContext) {
        ArtifactSelectorConfig artifactSelectorConfig = upgradeContext.getPluginArtifact(this.plugin.getType(), this.plugin.getName());
        ETLPlugin etlPlugin = new ETLPlugin(this.plugin.getName(), this.plugin.getType(), this.plugin.getProperties(), artifactSelectorConfig);
        return new ETLStage(this.name, etlPlugin, this.errorDatasetName);
    }

    public String toString() {
        return "ETLStage{name='" + this.name + '\'' + ", plugin=" + this.plugin + ", errorDatasetName='" + this.errorDatasetName + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ETLStage that = (ETLStage)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.plugin, that.plugin) && Objects.equals(this.errorDatasetName, that.errorDatasetName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.plugin, this.errorDatasetName);
    }
}

