/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.proto.v2;

import co.cask.cdap.api.Config;
import co.cask.cdap.api.Resources;
import co.cask.cdap.etl.proto.ArtifactSelectorConfig;
import co.cask.cdap.etl.proto.Connection;
import co.cask.cdap.etl.proto.UpgradeContext;
import co.cask.cdap.etl.proto.UpgradeableConfig;
import co.cask.cdap.etl.proto.v2.ETLStage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class ETLConfig
extends Config
implements UpgradeableConfig {
    private final Set<ETLStage> stages;
    private final Set<Connection> connections;
    private final Resources resources;
    private final Resources driverResources;
    private final Resources clientResources;
    private final Boolean stageLoggingEnabled;
    private final co.cask.cdap.etl.proto.v1.ETLStage source;
    private final List<co.cask.cdap.etl.proto.v1.ETLStage> sinks;
    private final List<co.cask.cdap.etl.proto.v1.ETLStage> transforms;
    private final Integer numOfRecordsPreview;

    protected ETLConfig(Set<ETLStage> stages, Set<Connection> connections, Resources resources, Resources driverResources, Resources clientResources, boolean stageLoggingEnabled, int numOfRecordsPreview) {
        this.stages = Collections.unmodifiableSet(stages);
        this.connections = Collections.unmodifiableSet(connections);
        this.resources = resources;
        this.driverResources = driverResources;
        this.clientResources = clientResources;
        this.stageLoggingEnabled = stageLoggingEnabled;
        this.source = null;
        this.sinks = new ArrayList<co.cask.cdap.etl.proto.v1.ETLStage>();
        this.transforms = new ArrayList<co.cask.cdap.etl.proto.v1.ETLStage>();
        this.numOfRecordsPreview = numOfRecordsPreview;
    }

    public Set<ETLStage> getStages() {
        return Collections.unmodifiableSet(this.stages == null ? new HashSet() : this.stages);
    }

    public Set<Connection> getConnections() {
        return Collections.unmodifiableSet(this.connections == null ? new HashSet() : this.connections);
    }

    public Resources getResources() {
        return this.resources == null ? new Resources(1024, 1) : this.resources;
    }

    public Resources getDriverResources() {
        return this.driverResources == null ? new Resources(1024, 1) : this.driverResources;
    }

    public Resources getClientResources() {
        return this.clientResources == null ? new Resources(1024, 1) : this.clientResources;
    }

    public int getNumOfRecordsPreview() {
        return this.numOfRecordsPreview == null ? 100 : this.numOfRecordsPreview;
    }

    public boolean isStageLoggingEnabled() {
        return this.stageLoggingEnabled == null ? true : this.stageLoggingEnabled;
    }

    public void validate() {
        for (ETLStage stage : this.getStages()) {
            stage.validate();
        }
    }

    protected <T extends Builder> T convertStages(T builder, String sourceType, String sinkType) {
        ((Builder)builder.setResources(this.getResources())).addConnections(this.getConnections());
        if (!this.isStageLoggingEnabled()) {
            builder.disableStageLogging();
        }
        UpgradeContext dummyUpgradeContext = new UpgradeContext(){

            @Override
            @Nullable
            public ArtifactSelectorConfig getPluginArtifact(String pluginType, String pluginName) {
                return null;
            }
        };
        if (this.source == null) {
            throw new IllegalArgumentException("Pipeline does not contain a source.");
        }
        builder.addStage(this.source.upgradeStage(sourceType, dummyUpgradeContext));
        if (this.transforms != null) {
            for (co.cask.cdap.etl.proto.v1.ETLStage v1Stage : this.transforms) {
                builder.addStage(v1Stage.upgradeStage("transform", dummyUpgradeContext));
            }
        }
        if (this.sinks == null || this.sinks.isEmpty()) {
            throw new IllegalArgumentException("Pipeline does not contain any sinks.");
        }
        for (co.cask.cdap.etl.proto.v1.ETLStage v1Stage : this.sinks) {
            builder.addStage(v1Stage.upgradeStage(sinkType, dummyUpgradeContext));
        }
        return builder;
    }

    public String toString() {
        return "ETLConfig{stages=" + this.stages + ", connections=" + this.connections + ", resources=" + this.resources + ", driverResources=" + this.driverResources + ", clientResources=" + this.clientResources + ", stageLoggingEnabled=" + this.stageLoggingEnabled + ", source=" + this.source + ", sinks=" + this.sinks + ", transforms=" + this.transforms + ", numOfRecordsPreview=" + this.numOfRecordsPreview + "} " + super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ETLConfig that = (ETLConfig)o;
        return Objects.equals(this.stages, that.stages) && Objects.equals(this.connections, that.connections) && Objects.equals(this.resources, that.resources) && Objects.equals(this.driverResources, that.driverResources) && Objects.equals(this.clientResources, that.clientResources) && this.isStageLoggingEnabled() == that.isStageLoggingEnabled();
    }

    public int hashCode() {
        return Objects.hash(this.stages, this.resources, this.isStageLoggingEnabled());
    }

    @Override
    public boolean canUpgrade() {
        return false;
    }

    public UpgradeableConfig upgrade(UpgradeContext upgradeContext) {
        throw new UnsupportedOperationException("This is the latest config and cannot be upgraded.");
    }

    public static abstract class Builder<T extends Builder> {
        protected Set<ETLStage> stages = new HashSet<ETLStage>();
        protected Set<Connection> connections = new HashSet<Connection>();
        protected Resources resources = new Resources(1024, 1);
        protected Resources driverResources = new Resources(1024, 1);
        protected Resources clientResources = new Resources(1024, 1);
        protected Boolean stageLoggingEnabled = true;
        protected int numOfRecordsPreview;

        protected Builder() {
        }

        public T addStage(ETLStage stage) {
            this.stages.add(stage);
            return (T)this;
        }

        public T addConnection(String from, String to) {
            this.connections.add(new Connection(from, to));
            return (T)this;
        }

        public T addConnection(Connection connection) {
            this.connections.add(connection);
            return (T)this;
        }

        public T addConnections(Collection<Connection> connections) {
            this.connections.addAll(connections);
            return (T)this;
        }

        public T setResources(Resources resources) {
            this.resources = resources;
            return (T)this;
        }

        public T setDriverResources(Resources resources) {
            this.driverResources = resources;
            return (T)this;
        }

        public T setClientResources(Resources resources) {
            this.clientResources = resources;
            return (T)this;
        }

        public T setNumOfRecordsPreview(int numOfRecordsPreview) {
            this.numOfRecordsPreview = numOfRecordsPreview;
            return (T)this;
        }

        public T disableStageLogging() {
            this.stageLoggingEnabled = false;
            return (T)this;
        }
    }
}

