/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.proto.v2;

import co.cask.cdap.api.Resources;
import co.cask.cdap.etl.proto.Connection;
import co.cask.cdap.etl.proto.v2.ETLConfig;
import co.cask.cdap.etl.proto.v2.ETLStage;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public final class DataStreamsConfig
extends ETLConfig {
    private final String batchInterval;
    private final String extraJavaOpts;
    private final Boolean disableCheckpoints;
    private final String checkpointDir;
    private final Boolean stopGracefully;
    private final boolean isUnitTest;

    private DataStreamsConfig(Set<ETLStage> stages, Set<Connection> connections, Resources resources, Resources driverResources, Resources clientResources, boolean stageLoggingEnabled, String batchInterval, boolean isUnitTest, boolean disableCheckpoints, @Nullable String checkpointDir, int numOfRecordsPreview, boolean stopGracefully) {
        super(stages, connections, resources, driverResources, clientResources, stageLoggingEnabled, numOfRecordsPreview);
        this.batchInterval = batchInterval;
        this.isUnitTest = isUnitTest;
        this.extraJavaOpts = "";
        this.disableCheckpoints = disableCheckpoints;
        this.checkpointDir = checkpointDir;
        this.stopGracefully = stopGracefully;
    }

    public String getBatchInterval() {
        return this.batchInterval;
    }

    public boolean isUnitTest() {
        return this.isUnitTest;
    }

    public boolean checkpointsDisabled() {
        return this.disableCheckpoints == null ? false : this.disableCheckpoints;
    }

    public String getExtraJavaOpts() {
        return this.extraJavaOpts == null || this.extraJavaOpts.isEmpty() ? "-XX:MaxPermSize=256m" : this.extraJavaOpts;
    }

    public Boolean getStopGracefully() {
        return this.stopGracefully == null ? true : this.stopGracefully;
    }

    @Nullable
    public String getCheckpointDir() {
        return this.checkpointDir;
    }

    @Override
    public String toString() {
        return "DataStreamsConfig{batchInterval='" + this.batchInterval + '\'' + ", extraJavaOpts='" + this.extraJavaOpts + '\'' + ", disableCheckpoints=" + this.disableCheckpoints + ", checkpointDir='" + this.checkpointDir + '\'' + ", stopGracefully=" + this.stopGracefully + ", isUnitTest=" + this.isUnitTest + "} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DataStreamsConfig that = (DataStreamsConfig)o;
        return Objects.equals(this.batchInterval, that.batchInterval) && Objects.equals(this.extraJavaOpts, that.extraJavaOpts) && Objects.equals(this.disableCheckpoints, that.disableCheckpoints) && Objects.equals(this.checkpointDir, that.checkpointDir) && Objects.equals(this.stopGracefully, that.stopGracefully);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.batchInterval, this.extraJavaOpts, this.disableCheckpoints, this.checkpointDir);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ETLConfig.Builder<Builder> {
        private final boolean isUnitTest;
        private String batchInterval = "1m";
        private String checkpointDir;
        private boolean stopGraceFully = true;

        public Builder() {
            this.isUnitTest = true;
        }

        public Builder setBatchInterval(String batchInterval) {
            this.batchInterval = batchInterval;
            return this;
        }

        public Builder setCheckpointDir(String checkpointDir) {
            this.checkpointDir = checkpointDir;
            return this;
        }

        public Builder setStopGracefully(boolean stopGraceFully) {
            this.stopGraceFully = stopGraceFully;
            return this;
        }

        public DataStreamsConfig build() {
            return new DataStreamsConfig(this.stages, this.connections, this.resources, this.driverResources, this.clientResources, this.stageLoggingEnabled, this.batchInterval, this.isUnitTest, false, this.checkpointDir, this.numOfRecordsPreview, this.stopGraceFully);
        }
    }
}

