/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.proto;

import co.cask.cdap.api.artifact.ArtifactScope;
import co.cask.cdap.api.artifact.ArtifactVersion;
import co.cask.cdap.etl.proto.ArtifactSelector;
import com.google.common.base.CharMatcher;
import java.util.Objects;

public class ArtifactSelectorConfig {
    private static final CharMatcher nameMatcher = CharMatcher.inRange((char)'A', (char)'Z').or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.is((char)'_')).or(CharMatcher.is((char)'-'));
    private final String scope;
    private final String name;
    private final String version;

    public ArtifactSelectorConfig() {
        this.scope = null;
        this.name = null;
        this.version = null;
    }

    public ArtifactSelectorConfig(String scope, String name, String version) {
        this.scope = scope;
        this.name = name;
        this.version = version;
    }

    public ArtifactSelector getArtifactSelector(String pluginType, String pluginName) {
        if (this.name != null && !nameMatcher.matchesAllOf((CharSequence)this.name)) {
            throw new IllegalArgumentException(String.format("'%s' is an invalid artifact name. Must contain only alphanumeric, '-', or '_' characters.", this.name));
        }
        ArtifactVersion artifactVersion = null;
        if (this.version != null && (artifactVersion = new ArtifactVersion(this.version)).getVersion() == null) {
            throw new IllegalArgumentException(String.format("Could not parse '%s' as an artifact version.", this.version));
        }
        ArtifactScope artifactScope = this.scope == null ? null : ArtifactScope.valueOf((String)this.scope.toUpperCase());
        return new ArtifactSelector(pluginType, pluginName, artifactScope, this.name, artifactVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactSelectorConfig that = (ArtifactSelectorConfig)o;
        return Objects.equals(this.scope, that.scope) && Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.scope, this.name, this.version);
    }

    public String toString() {
        return "ArtifactSelectorConfig{scope='" + this.scope + '\'' + ", name='" + this.name + '\'' + ", version='" + this.version + '\'' + '}';
    }
}

