/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.proto.v0;

import co.cask.cdap.api.Config;
import co.cask.cdap.api.Resources;
import co.cask.cdap.etl.proto.UpgradeContext;
import co.cask.cdap.etl.proto.v0.ETLStage;
import co.cask.cdap.etl.proto.v1.ETLConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ETLConfig
extends Config {
    private final ETLStage source;
    private final List<ETLStage> sinks;
    private final List<ETLStage> transforms;
    private final Resources resources;

    public ETLConfig(ETLStage source, List<ETLStage> sinks, List<ETLStage> transforms, Resources resources) {
        this.source = source;
        this.sinks = sinks;
        this.transforms = transforms;
        this.resources = resources;
    }

    public ETLStage getSource() {
        return this.source;
    }

    public List<ETLStage> getSinks() {
        return Collections.unmodifiableList(this.sinks == null ? new ArrayList() : this.sinks);
    }

    public List<ETLStage> getTransforms() {
        return Collections.unmodifiableList(this.transforms == null ? new ArrayList() : this.transforms);
    }

    public Resources getResources() {
        return this.resources == null ? new Resources() : this.resources;
    }

    protected <T extends ETLConfig.Builder> T upgradeBase(T builder, UpgradeContext upgradeContext, String sourceType, String sinkType) {
        String currStageName;
        builder.setResources(this.resources);
        String prevStageName = this.getSource().getName() + ".1";
        builder.setSource(this.getSource().upgradeStage(prevStageName, sourceType, upgradeContext));
        int stageNum = 2;
        for (ETLStage v0Transform : this.getTransforms()) {
            currStageName = v0Transform.getName() + "." + stageNum;
            builder.addTransform(v0Transform.upgradeStage(currStageName, "transform", upgradeContext));
            builder.addConnection(prevStageName, currStageName);
            prevStageName = currStageName;
            ++stageNum;
        }
        for (ETLStage v0Sink : this.getSinks()) {
            currStageName = v0Sink.getName() + "." + stageNum;
            builder.addSink(v0Sink.upgradeStage(currStageName, sinkType, upgradeContext));
            builder.addConnection(prevStageName, currStageName);
            ++stageNum;
        }
        return builder;
    }
}

