/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.proto;

import co.cask.cdap.api.artifact.ArtifactId;
import co.cask.cdap.api.artifact.ArtifactScope;
import co.cask.cdap.api.artifact.ArtifactVersion;
import co.cask.cdap.api.plugin.PluginClass;
import co.cask.cdap.api.plugin.PluginSelector;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class ArtifactSelector
extends PluginSelector {
    private final ArtifactScope scope;
    private final String name;
    private final ArtifactVersion version;
    private final String errMsg;

    public ArtifactSelector(String pluginType, String pluginName, @Nullable ArtifactScope scope, @Nullable String name, @Nullable ArtifactVersion version) {
        this.scope = scope;
        this.name = name;
        this.version = version;
        StringBuilder msg = new StringBuilder("Could not find an artifact that matches");
        if (scope != null) {
            msg.append(" scope ");
            msg.append(scope.name());
        }
        if (name != null) {
            msg.append(" name ");
            msg.append(name);
        }
        if (version != null) {
            msg.append(" version ");
            msg.append(version.getVersion());
        }
        msg.append(" for plugin of type ");
        msg.append(pluginType);
        msg.append(" and name ");
        msg.append(pluginName);
        this.errMsg = msg.toString();
    }

    public Map.Entry<ArtifactId, PluginClass> select(SortedMap<ArtifactId, PluginClass> plugins) {
        TreeMap<ArtifactId, PluginClass> pluginMap;
        if (plugins instanceof NavigableMap) {
            pluginMap = (TreeMap<ArtifactId, PluginClass>)plugins;
        } else {
            pluginMap = new TreeMap<ArtifactId, PluginClass>();
            pluginMap.putAll(plugins);
        }
        for (Map.Entry<ArtifactId, PluginClass> entry : pluginMap.descendingMap().entrySet()) {
            ArtifactId artifactId = (ArtifactId)entry.getKey();
            if (this.scope != null && !artifactId.getScope().equals((Object)this.scope) || this.name != null && !artifactId.getName().equals(this.name) || this.version != null && !artifactId.getVersion().equals((Object)this.version)) continue;
            return entry;
        }
        throw new IllegalArgumentException(this.errMsg);
    }
}

