/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.proto.v2;

import co.cask.cdap.api.plugin.PluginProperties;
import co.cask.cdap.api.plugin.PluginSelector;
import co.cask.cdap.etl.proto.ArtifactSelectorConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class ETLPlugin {
    private final String name;
    private final String type;
    private final Map<String, String> properties;
    private final ArtifactSelectorConfig artifact;

    public ETLPlugin(String name, String type, Map<String, String> properties, @Nullable ArtifactSelectorConfig artifact) {
        this.name = name;
        this.type = type;
        this.properties = Collections.unmodifiableMap(properties);
        this.artifact = artifact;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties == null ? new HashMap() : this.properties);
    }

    public PluginProperties getPluginProperties() {
        if (this.properties == null || this.properties.isEmpty()) {
            return PluginProperties.builder().build();
        }
        return PluginProperties.builder().addAll(this.properties).build();
    }

    public void validate() {
        if (this.name == null || this.name.isEmpty()) {
            throw new IllegalArgumentException("Invalid plugin " + this.toString() + ": name must be specified.");
        }
        if (this.type == null || this.type.isEmpty()) {
            throw new IllegalArgumentException("Invalid plugin " + this.toString() + ": type must be specified.");
        }
    }

    public PluginSelector getPluginSelector() {
        return this.artifact == null ? new PluginSelector() : this.artifact.getArtifactSelector(this.type, this.name);
    }

    public String toString() {
        return "Plugin{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", properties=" + this.properties + ", artifact=" + this.artifact + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ETLPlugin that = (ETLPlugin)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.properties, that.properties) && Objects.equals(this.artifact, that.artifact);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.properties, this.artifact);
    }
}

