/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.proto.v2;

import co.cask.cdap.api.Resources;
import co.cask.cdap.etl.proto.Connection;
import co.cask.cdap.etl.proto.v2.ETLConfig;
import co.cask.cdap.etl.proto.v2.ETLStage;
import java.util.Objects;
import java.util.Set;

public final class DataStreamsConfig
extends ETLConfig {
    private final String batchInterval;
    private final Resources driverResources;
    private final String extraJavaOpts;
    private final boolean isUnitTest;

    private DataStreamsConfig(Set<ETLStage> stages, Set<Connection> connections, Resources resources, Resources driverResources, boolean stageLoggingEnabled, String batchInterval, boolean isUnitTest) {
        super(stages, connections, resources, stageLoggingEnabled);
        this.batchInterval = batchInterval;
        this.driverResources = driverResources;
        this.isUnitTest = isUnitTest;
        this.extraJavaOpts = "";
    }

    public Resources getDriverResources() {
        return this.driverResources;
    }

    public String getBatchInterval() {
        return this.batchInterval;
    }

    public boolean isUnitTest() {
        return this.isUnitTest;
    }

    public String getExtraJavaOpts() {
        return this.extraJavaOpts == null || this.extraJavaOpts.isEmpty() ? "-XX:MaxPermSize=256m" : this.extraJavaOpts;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DataStreamsConfig that = (DataStreamsConfig)o;
        return Objects.equals(this.batchInterval, that.batchInterval) && Objects.equals(this.driverResources, that.driverResources) && Objects.equals(this.extraJavaOpts, that.extraJavaOpts);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.batchInterval, this.driverResources, this.extraJavaOpts);
    }

    @Override
    public String toString() {
        return "DataStreamsConfig{batchInterval='" + this.batchInterval + '\'' + ", driverResources=" + this.driverResources + ", extraJavaOpts='" + this.extraJavaOpts + '\'' + ", isUnitTest=" + this.isUnitTest + "} " + super.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ETLConfig.Builder<Builder> {
        private final boolean isUnitTest;
        private String batchInterval = "1m";
        private Resources driverResources = new Resources();

        public Builder() {
            this.isUnitTest = true;
        }

        public Builder setBatchInterval(String batchInterval) {
            this.batchInterval = batchInterval;
            return this;
        }

        public Builder setDriverResources(Resources driverResources) {
            this.driverResources = driverResources;
            return this;
        }

        public DataStreamsConfig build() {
            return new DataStreamsConfig(this.stages, this.connections, this.resources, this.driverResources, this.stageLoggingEnabled, this.batchInterval, this.isUnitTest);
        }
    }
}

