/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.proto.v0;

import co.cask.cdap.api.Resources;
import co.cask.cdap.etl.proto.UpgradeContext;
import co.cask.cdap.etl.proto.UpgradeableConfig;
import co.cask.cdap.etl.proto.v0.ETLConfig;
import co.cask.cdap.etl.proto.v0.ETLStage;
import co.cask.cdap.etl.proto.v1.ETLBatchConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ETLBatchConfig
extends ETLConfig
implements UpgradeableConfig<co.cask.cdap.etl.proto.v1.ETLBatchConfig> {
    private final String schedule;
    private final List<ETLStage> actions;

    public ETLBatchConfig(String schedule, ETLStage source, List<ETLStage> sinks, List<ETLStage> transforms, Resources resources, List<ETLStage> actions) {
        super(source, sinks, transforms, resources);
        this.schedule = schedule;
        this.actions = actions;
    }

    public List<ETLStage> getActions() {
        return Collections.unmodifiableList(this.actions == null ? new ArrayList() : this.actions);
    }

    @Override
    public boolean canUpgrade() {
        return true;
    }

    @Override
    public co.cask.cdap.etl.proto.v1.ETLBatchConfig upgrade(UpgradeContext upgradeContext) {
        ETLBatchConfig.Builder builder = co.cask.cdap.etl.proto.v1.ETLBatchConfig.builder(this.schedule).setEngine(ETLBatchConfig.Engine.MAPREDUCE).setDriverResources(this.getResources());
        this.upgradeBase(builder, upgradeContext, "batchsource", "batchsink");
        int actionNum = 1;
        for (ETLStage v0Action : this.getActions()) {
            builder.addAction(v0Action.upgradeStage(v0Action.getName() + "." + actionNum, "action", upgradeContext));
            ++actionNum;
        }
        return builder.build();
    }
}

