/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.proto.v1;

import co.cask.cdap.api.plugin.PluginSelector;
import co.cask.cdap.etl.proto.ArtifactSelectorConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class Plugin {
    private final String name;
    private final Map<String, String> properties;
    private final ArtifactSelectorConfig artifact;

    public Plugin(String name, Map<String, String> properties, @Nullable ArtifactSelectorConfig artifact) {
        this.name = name;
        this.properties = properties;
        this.artifact = artifact;
    }

    public Plugin(String name, Map<String, String> properties) {
        this(name, properties, null);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties == null ? Collections.unmodifiableMap(new HashMap()) : this.properties;
    }

    public ArtifactSelectorConfig getArtifact() {
        return this.artifact == null ? new ArtifactSelectorConfig() : this.artifact;
    }

    public PluginSelector getPluginSelector(String pluginType, String pluginName) {
        return this.artifact == null ? new PluginSelector() : this.artifact.getArtifactSelector(pluginType, pluginName);
    }

    public String toString() {
        return "Plugin{name='" + this.name + '\'' + ", properties=" + this.properties + ", artifact=" + this.artifact + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Plugin that = (Plugin)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.properties, that.properties) && Objects.equals(this.artifact, that.artifact);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.properties, this.artifact);
    }
}

