/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.realtime;

import co.cask.cdap.api.metrics.Metrics;
import co.cask.cdap.api.plugin.PluginProperties;
import co.cask.cdap.api.worker.WorkerContext;
import co.cask.cdap.etl.api.TransformContext;
import co.cask.cdap.etl.common.PluginID;
import co.cask.cdap.etl.common.ScopedPluginContext;
import co.cask.cdap.etl.common.StageMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealtimeTransformContext
extends ScopedPluginContext
implements TransformContext {
    private static final Logger LOG = LoggerFactory.getLogger(RealtimeTransformContext.class);
    private final WorkerContext context;
    private final Metrics metrics;

    public RealtimeTransformContext(WorkerContext context, Metrics metrics, String stageId) {
        super(stageId);
        this.context = context;
        this.metrics = metrics;
    }

    public Metrics getMetrics() {
        return new StageMetrics(this.metrics, PluginID.from(this.stageId));
    }

    public int getStageId() {
        return PluginID.from(this.stageId).getStage();
    }

    @Override
    protected <T> T newScopedPluginInstance(String scopedPluginId) throws InstantiationException {
        return (T)this.context.newPluginInstance(scopedPluginId);
    }

    @Override
    protected <T> Class<T> loadScopedPluginClass(String scopedPluginId) {
        return this.context.loadPluginClass(scopedPluginId);
    }

    public PluginProperties getPluginProperties() {
        return this.context.getPluginProperties(this.stageId);
    }

    @Override
    public PluginProperties getScopedPluginProperties(String scopedPluginId) {
        return this.context.getPluginProperties(scopedPluginId);
    }
}

