/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.common;

import co.cask.cdap.etl.api.Destroyable;
import co.cask.cdap.etl.api.Emitter;
import co.cask.cdap.etl.api.Transformation;
import co.cask.cdap.etl.common.DefaultEmitter;
import co.cask.cdap.etl.common.Destroyables;
import co.cask.cdap.etl.common.TrackedTransform;
import co.cask.cdap.etl.common.TransformDetail;
import co.cask.cdap.etl.common.TransformResponse;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformExecutor<IN, OUT>
implements Destroyable {
    private static final Logger LOG = LoggerFactory.getLogger(TransformExecutor.class);
    private final List<TransformDetail> transforms;
    private final List<DefaultEmitter> emitters;

    public TransformExecutor(List<TransformDetail> transformDetailList) {
        int numTransforms = transformDetailList.size();
        this.transforms = new ArrayList<TransformDetail>(numTransforms);
        this.emitters = Lists.newArrayListWithCapacity((int)numTransforms);
        for (TransformDetail transformDetail : transformDetailList) {
            this.transforms.add(new TransformDetail(transformDetail, new TrackedTransform(transformDetail.getTransformation(), transformDetail.getMetrics())));
            this.emitters.add(new DefaultEmitter(transformDetail.getMetrics()));
        }
    }

    public TransformResponse<OUT> runOneIteration(IN input) throws Exception {
        HashMap errorRecordsMap = new HashMap(this.transforms.size());
        if (this.transforms.isEmpty()) {
            return new TransformResponse(Lists.newArrayList((Object[])new Object[]{input}).iterator(), errorRecordsMap);
        }
        TransformDetail transformDetail = this.transforms.get(0);
        DefaultEmitter currentEmitter = this.emitters.get(0);
        currentEmitter.reset();
        Transformation transform = transformDetail.getTransformation();
        transform.transform(input, (Emitter)currentEmitter);
        if (!currentEmitter.getErrors().isEmpty()) {
            errorRecordsMap.put(transformDetail.getTransformId(), currentEmitter.getErrors());
        }
        DefaultEmitter previousEmitter = currentEmitter;
        for (int i = 1; i < this.transforms.size(); ++i) {
            transformDetail = this.transforms.get(i);
            transform = transformDetail.getTransformation();
            currentEmitter = this.emitters.get(i);
            for (Object transformedVal : previousEmitter) {
                transform.transform(transformedVal, (Emitter)currentEmitter);
            }
            if (!currentEmitter.getErrors().isEmpty()) {
                errorRecordsMap.put(transformDetail.getTransformId(), currentEmitter.getErrors());
            }
            previousEmitter = currentEmitter;
        }
        return new TransformResponse(previousEmitter.iterator(), errorRecordsMap);
    }

    public void resetEmitters() {
        for (DefaultEmitter emitter : this.emitters) {
            emitter.reset();
        }
    }

    public void destroy() {
        for (TransformDetail transformDetail : this.transforms) {
            Transformation transformation = transformDetail.getTransformation();
            if (!(transformation instanceof Destroyable)) continue;
            Destroyables.destroyQuietly((Destroyable)transformation);
        }
    }
}

