/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.common;

import co.cask.cdap.api.metrics.Metrics;
import co.cask.cdap.etl.api.Destroyable;
import co.cask.cdap.etl.api.Emitter;
import co.cask.cdap.etl.api.Transformation;

public class TrackedTransform<IN, OUT>
implements Transformation<IN, OUT>,
Destroyable {
    private final Transformation<IN, OUT> transform;
    private final Metrics metrics;

    public TrackedTransform(Transformation<IN, OUT> transform, Metrics metrics) {
        this.transform = transform;
        this.metrics = metrics;
    }

    public void transform(IN input, Emitter<OUT> emitter) throws Exception {
        this.metrics.count("records.in", 1);
        this.transform.transform(input, emitter);
    }

    public void destroy() {
        if (this.transform instanceof Destroyable) {
            ((Destroyable)this.transform).destroy();
        }
    }
}

