/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.common;

import com.google.common.base.Splitter;
import java.util.Iterator;
import java.util.Objects;

public class PluginID {
    private final String type;
    private final String name;
    private final int stage;

    public static PluginID from(String idStr) {
        Iterator parts = Splitter.on((char)':').split((CharSequence)idStr).iterator();
        return new PluginID((String)parts.next(), (String)parts.next(), Integer.valueOf((String)parts.next()));
    }

    public static PluginID from(String type, String name, int stage) {
        return new PluginID(type, name, stage);
    }

    private PluginID(String type, String name, int stage) {
        this.type = type;
        this.name = name;
        this.stage = stage;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public int getStage() {
        return this.stage;
    }

    public String getMetricsContext() {
        return String.format("%s.%s.%d", this.type, this.name, this.stage);
    }

    public String getID() {
        return String.format("%s:%s:%d", this.type, this.name, this.stage);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginID that = (PluginID)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.name, that.name) && this.stage == that.stage;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, this.stage);
    }
}

