/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.common;

import co.cask.cdap.api.dataset.DatasetProperties;
import co.cask.cdap.api.plugin.PluginConfigurer;
import co.cask.cdap.api.plugin.PluginProperties;
import co.cask.cdap.etl.api.PipelineConfigurable;
import co.cask.cdap.etl.api.PipelineConfigurer;
import co.cask.cdap.etl.api.Transform;
import co.cask.cdap.etl.api.Transformation;
import co.cask.cdap.etl.api.realtime.RealtimeSink;
import co.cask.cdap.etl.api.realtime.RealtimeSource;
import co.cask.cdap.etl.common.DefaultPipelineConfigurer;
import co.cask.cdap.etl.common.ETLConfig;
import co.cask.cdap.etl.common.ETLStage;
import co.cask.cdap.etl.common.Pipeline;
import co.cask.cdap.etl.common.PluginID;
import co.cask.cdap.etl.common.SinkInfo;
import co.cask.cdap.etl.common.TransformInfo;
import co.cask.cdap.etl.common.guice.TypeResolver;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;

public class PipelineRegisterer {
    private final PluginConfigurer configurer;
    private final String sourcePluginType;
    private final String sinkPluginType;

    public PipelineRegisterer(PluginConfigurer configurer, String programType) {
        this.configurer = configurer;
        this.sourcePluginType = programType + "source";
        this.sinkPluginType = programType + "sink";
    }

    public Pipeline registerPlugins(ETLConfig config, Class errorDatasetType, DatasetProperties errorDatasetProperties, boolean sinkWithErrorDataset) {
        ETLStage sourceConfig = config.getSource();
        List<ETLStage> transformConfigs = config.getTransforms();
        List<ETLStage> sinkConfigs = config.getSinks();
        if (sinkConfigs == null) {
            throw new IllegalArgumentException("At least one sink must be specified.");
        }
        if (sourceConfig == null) {
            throw new IllegalArgumentException("A source must be specified.");
        }
        if (sinkConfigs.isEmpty()) {
            throw new IllegalArgumentException("At least one sink must be specified.");
        }
        int pluginNum = 1;
        String sourcePluginId = PluginID.from("source", sourceConfig.getName(), pluginNum).getID();
        ++pluginNum;
        PipelineConfigurable source = (PipelineConfigurable)this.configurer.usePlugin(this.sourcePluginType, sourceConfig.getName(), sourcePluginId, this.getPluginProperties(sourceConfig));
        if (source == null) {
            throw new IllegalArgumentException(String.format("No Plugin of type '%s' named '%s' was found.", "source", sourceConfig.getName()));
        }
        DefaultPipelineConfigurer sourceConfigurer = new DefaultPipelineConfigurer(this.configurer, sourcePluginId);
        source.configurePipeline((PipelineConfigurer)sourceConfigurer);
        ArrayList<TransformInfo> transformInfos = new ArrayList<TransformInfo>(transformConfigs.size());
        ArrayList<Transformation> transforms = new ArrayList<Transformation>(transformConfigs.size());
        for (ETLStage transformConfig : transformConfigs) {
            String transformId = PluginID.from("transform", transformConfig.getName(), pluginNum).getID();
            PluginProperties transformProperties = this.getPluginProperties(transformConfig);
            Transform transformObj = (Transform)this.configurer.usePlugin("transform", transformConfig.getName(), transformId, transformProperties);
            if (transformObj == null) {
                throw new IllegalArgumentException(String.format("No Plugin of type '%s' named '%s' was found", "transform", transformConfig.getName()));
            }
            if (transformConfig.getErrorDatasetName() != null) {
                this.configurer.createDataset(transformConfig.getErrorDatasetName(), errorDatasetType, errorDatasetProperties);
            }
            DefaultPipelineConfigurer transformConfigurer = new DefaultPipelineConfigurer(this.configurer, transformId);
            transformObj.configurePipeline((PipelineConfigurer)transformConfigurer);
            transformInfos.add(new TransformInfo(transformId, transformConfig.getErrorDatasetName()));
            transforms.add((Transformation)transformObj);
            ++pluginNum;
        }
        ArrayList<SinkInfo> sinksInfo = new ArrayList<SinkInfo>();
        ArrayList<PipelineConfigurable> sinks = new ArrayList<PipelineConfigurable>();
        for (ETLStage sinkConfig : sinkConfigs) {
            String sinkPluginId = PluginID.from("sink", sinkConfig.getName(), pluginNum).getID();
            if (sinkWithErrorDataset && sinkConfig.getErrorDatasetName() != null) {
                this.configurer.createDataset(sinkConfig.getErrorDatasetName(), errorDatasetType, errorDatasetProperties);
            }
            sinksInfo.add(new SinkInfo(sinkPluginId, sinkConfig.getErrorDatasetName()));
            PipelineConfigurable sink = (PipelineConfigurable)this.configurer.usePlugin(this.sinkPluginType, sinkConfig.getName(), sinkPluginId, this.getPluginProperties(sinkConfig));
            if (sink == null) {
                throw new IllegalArgumentException(String.format("No Plugin of type '%s' named '%s' was found. Please check that an artifact containing the plugin exists, and that it extends the etl application.", "sink", sinkConfig.getName()));
            }
            DefaultPipelineConfigurer sinkConfigurer = new DefaultPipelineConfigurer(this.configurer, sinkPluginId);
            sink.configurePipeline((PipelineConfigurer)sinkConfigurer);
            sinks.add(sink);
            ++pluginNum;
        }
        try {
            PipelineRegisterer.validateStages(source, sinks, transforms);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new Pipeline(sourcePluginId, sinksInfo, transformInfos);
    }

    private PluginProperties getPluginProperties(ETLStage config) {
        PluginProperties.Builder builder = PluginProperties.builder();
        if (config.getProperties() != null) {
            builder.addAll(config.getProperties());
        }
        return builder.build();
    }

    public static void validateStages(PipelineConfigurable source, List<PipelineConfigurable> sinks, List<Transformation> transforms) throws Exception {
        ArrayList unresTypeList = Lists.newArrayListWithCapacity((int)(transforms.size() + 2));
        TypeVariable inType = Transformation.class.getTypeParameters()[0];
        TypeVariable outType = Transformation.class.getTypeParameters()[1];
        Class<?> sourceClass = source.getClass();
        TypeToken sourceToken = TypeToken.of(sourceClass);
        if (RealtimeSource.class.isAssignableFrom(sourceClass)) {
            TypeVariable type = RealtimeSource.class.getTypeParameters()[0];
            unresTypeList.add(sourceToken.resolveType(type).getType());
        } else {
            unresTypeList.add(sourceToken.resolveType(outType).getType());
        }
        for (Transformation transform : transforms) {
            Class<?> klass = transform.getClass();
            TypeToken transformToken = TypeToken.of(klass);
            unresTypeList.add(transformToken.resolveType(inType).getType());
            unresTypeList.add(transformToken.resolveType(outType).getType());
        }
        for (PipelineConfigurable sink : sinks) {
            Class<?> sinkClass = sink.getClass();
            TypeToken sinkToken = TypeToken.of(sinkClass);
            ArrayList pipelineTypes = Lists.newArrayList((Iterable)unresTypeList);
            if (RealtimeSink.class.isAssignableFrom(sinkClass)) {
                TypeVariable type = RealtimeSink.class.getTypeParameters()[0];
                pipelineTypes.add(sinkToken.resolveType(type).getType());
            } else {
                pipelineTypes.add(sinkToken.resolveType(inType).getType());
            }
            PipelineRegisterer.validateTypes(pipelineTypes);
        }
    }

    @VisibleForTesting
    static void validateTypes(List<Type> unresTypeList) {
        int i;
        Preconditions.checkArgument((unresTypeList.size() % 2 == 0 ? 1 : 0) != 0, (Object)"ETL Stages validation expects even number of types");
        ArrayList resTypeList = Lists.newArrayListWithCapacity((int)unresTypeList.size());
        resTypeList.add(unresTypeList.get(0));
        try {
            Type nType = new TypeResolver().where(unresTypeList.get(1), (Type)resTypeList.get(0)).resolveType(unresTypeList.get(1));
            resTypeList.add(nType);
        }
        catch (IllegalArgumentException e) {
            resTypeList.add(unresTypeList.get(1));
        }
        for (i = 2; i < unresTypeList.size(); ++i) {
            Type actualType = (Type)resTypeList.get(i - 1);
            Type formalType = unresTypeList.get(i - 1);
            Type toResolveType = unresTypeList.get(i);
            try {
                Type newType = toResolveType instanceof TypeVariable || toResolveType instanceof GenericArrayType ? new TypeResolver().where(toResolveType, actualType).resolveType(toResolveType) : new TypeResolver().where(formalType, actualType).resolveType(toResolveType);
                resTypeList.add(newType);
                continue;
            }
            catch (IllegalArgumentException e) {
                resTypeList.add(toResolveType);
            }
        }
        for (i = 0; i < resTypeList.size(); i += 2) {
            Type firstType = (Type)resTypeList.get(i);
            Type secondType = (Type)resTypeList.get(i + 1);
            Preconditions.checkArgument((boolean)TypeToken.of((Type)secondType).isAssignableFrom(firstType), (String)"Types between stages didn't match. Mismatch between {} -> {}", (Object[])new Object[]{firstType, secondType});
        }
    }
}

