/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.common;

import co.cask.cdap.api.Config;
import co.cask.cdap.api.Resources;
import co.cask.cdap.etl.common.ETLStage;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class ETLConfig
extends Config {
    private final ETLStage source;
    private final List<ETLStage> sinks;
    private final List<ETLStage> transforms;
    private final Resources resources;

    public ETLConfig(ETLStage source, List<ETLStage> sinks, List<ETLStage> transforms, Resources resources) {
        this.source = source;
        this.sinks = sinks;
        this.transforms = transforms;
        this.resources = resources;
    }

    public ETLConfig(ETLStage source, ETLStage sink, List<ETLStage> transforms, Resources resources) {
        this.source = source;
        this.sinks = new ArrayList<ETLStage>();
        this.sinks.add(sink);
        this.transforms = transforms;
        this.resources = resources;
    }

    public ETLStage getSource() {
        return this.source;
    }

    public List<ETLStage> getSinks() {
        return this.sinks;
    }

    public List<ETLStage> getTransforms() {
        return this.transforms != null ? this.transforms : Lists.newArrayList();
    }

    public Resources getResources() {
        return this.resources;
    }
}

