/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.common;

import co.cask.cdap.api.data.stream.Stream;
import co.cask.cdap.api.dataset.Dataset;
import co.cask.cdap.api.dataset.DatasetProperties;
import co.cask.cdap.api.dataset.module.DatasetModule;
import co.cask.cdap.api.plugin.PluginConfigurer;
import co.cask.cdap.api.plugin.PluginProperties;
import co.cask.cdap.api.plugin.PluginSelector;
import co.cask.cdap.etl.api.PipelineConfigurer;
import javax.annotation.Nullable;

public class DefaultPipelineConfigurer
implements PipelineConfigurer {
    private final PluginConfigurer configurer;
    private final String pluginPrefix;

    public DefaultPipelineConfigurer(PluginConfigurer configurer, String pluginPrefix) {
        this.configurer = configurer;
        this.pluginPrefix = pluginPrefix;
    }

    public void addStream(Stream stream) {
        this.configurer.addStream(stream);
    }

    public void addStream(String streamName) {
        this.configurer.addStream(streamName);
    }

    public void addDatasetModule(String moduleName, Class<? extends DatasetModule> moduleClass) {
        this.configurer.addDatasetModule(moduleName, moduleClass);
    }

    public void addDatasetType(Class<? extends Dataset> datasetClass) {
        this.configurer.addDatasetType(datasetClass);
    }

    public void createDataset(String datasetName, String typeName, DatasetProperties properties) {
        this.configurer.createDataset(datasetName, typeName, properties);
    }

    public void createDataset(String datasetName, String typeName) {
        this.configurer.createDataset(datasetName, typeName);
    }

    public void createDataset(String datasetName, Class<? extends Dataset> datasetClass, DatasetProperties props) {
        this.configurer.createDataset(datasetName, datasetClass, props);
    }

    public void createDataset(String datasetName, Class<? extends Dataset> datasetClass) {
        this.configurer.createDataset(datasetName, datasetClass);
    }

    @Nullable
    public <T> T usePlugin(String pluginType, String pluginName, String pluginId, PluginProperties properties) {
        return (T)this.configurer.usePlugin(pluginType, pluginName, this.getPluginId(pluginId), properties);
    }

    @Nullable
    public <T> T usePlugin(String pluginType, String pluginName, String pluginId, PluginProperties properties, PluginSelector selector) {
        return (T)this.configurer.usePlugin(pluginType, pluginName, pluginId, properties, selector);
    }

    @Nullable
    public <T> Class<T> usePluginClass(String pluginType, String pluginName, String pluginId, PluginProperties properties) {
        return this.configurer.usePluginClass(pluginType, pluginName, this.getPluginId(pluginId), properties);
    }

    @Nullable
    public <T> Class<T> usePluginClass(String pluginType, String pluginName, String pluginId, PluginProperties properties, PluginSelector selector) {
        return this.configurer.usePluginClass(pluginType, pluginName, pluginId, properties, selector);
    }

    private String getPluginId(String childPluginId) {
        return String.format("%s%s%s", this.pluginPrefix, ":", childPluginId);
    }
}

