/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.common;

import co.cask.cdap.api.metrics.Metrics;
import co.cask.cdap.etl.api.Emitter;
import co.cask.cdap.etl.api.InvalidEntry;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DefaultEmitter<T>
implements Emitter<T>,
Iterable<T> {
    private final List<T> entryList = Lists.newArrayList();
    private final List<InvalidEntry<T>> errorList = Lists.newArrayList();
    private final Metrics metrics;

    public DefaultEmitter(Metrics metrics) {
        this.metrics = metrics;
    }

    public void emit(T value) {
        this.entryList.add(value);
        this.metrics.count("records.out", 1);
    }

    public void emitError(InvalidEntry<T> value) {
        this.errorList.add(value);
        this.metrics.count("records.error", 1);
    }

    @Override
    public Iterator<T> iterator() {
        return this.entryList.iterator();
    }

    public Collection<InvalidEntry<T>> getErrors() {
        return this.errorList;
    }

    public void reset() {
        this.entryList.clear();
        this.errorList.clear();
    }
}

