/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.batch;

import co.cask.cdap.api.data.DatasetInstantiationException;
import co.cask.cdap.api.dataset.Dataset;
import co.cask.cdap.api.mapreduce.MapReduceTaskContext;
import co.cask.cdap.api.metrics.Metrics;
import co.cask.cdap.api.plugin.PluginProperties;
import co.cask.cdap.etl.api.batch.BatchRuntimeContext;
import co.cask.cdap.etl.common.PluginID;
import co.cask.cdap.etl.common.ScopedPluginContext;
import co.cask.cdap.etl.common.StageMetrics;
import java.util.Map;

public class MapReduceRuntimeContext
extends ScopedPluginContext
implements BatchRuntimeContext {
    private final MapReduceTaskContext context;
    private final Metrics metrics;

    public MapReduceRuntimeContext(MapReduceTaskContext context, Metrics metrics, String stageId) {
        super(stageId);
        this.context = context;
        this.metrics = metrics;
    }

    public Metrics getMetrics() {
        return new StageMetrics(this.metrics, PluginID.from(this.stageId));
    }

    public int getStageId() {
        return PluginID.from(this.stageId).getStage();
    }

    @Override
    protected <T> T newScopedPluginInstance(String scopedPluginId) throws InstantiationException {
        return (T)this.context.newPluginInstance(scopedPluginId);
    }

    @Override
    protected <T> Class<T> loadScopedPluginClass(String scopedPluginId) {
        return this.context.loadPluginClass(scopedPluginId);
    }

    public PluginProperties getPluginProperties() {
        return this.context.getPluginProperties(this.stageId);
    }

    @Override
    public PluginProperties getScopedPluginProperties(String scopedPluginId) {
        return this.context.getPluginProperties(scopedPluginId);
    }

    public long getLogicalStartTime() {
        return this.context.getLogicalStartTime();
    }

    public Map<String, String> getRuntimeArguments() {
        return this.context.getRuntimeArguments();
    }

    public <T extends Dataset> T getDataset(String name) throws DatasetInstantiationException {
        return (T)this.context.getDataset(name);
    }

    public <T extends Dataset> T getDataset(String name, Map<String, String> arguments) throws DatasetInstantiationException {
        return (T)this.context.getDataset(name, arguments);
    }
}

