/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.common;

import co.cask.cdap.api.common.Bytes;
import co.cask.cdap.api.data.format.StructuredRecord;
import co.cask.cdap.api.data.schema.Schema;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class StructuredRecordStringConverter {
    private static final Map<Class<?>, Schema.Type> TYPE_TO_SCHEMA = new IdentityHashMap((Map<Class<?>, Schema.Type>)ImmutableMap.builder().put(Boolean.class, (Object)Schema.Type.BOOLEAN).put(Byte.class, (Object)Schema.Type.INT).put(Short.class, (Object)Schema.Type.INT).put(Integer.class, (Object)Schema.Type.INT).put(Long.class, (Object)Schema.Type.LONG).put(Float.class, (Object)Schema.Type.FLOAT).put(Double.class, (Object)Schema.Type.DOUBLE).put(String.class, (Object)Schema.Type.STRING).put(ByteBuffer.class, (Object)Schema.Type.BYTES).put(byte[].class, (Object)Schema.Type.BYTES).put(StructuredRecord.class, (Object)Schema.Type.RECORD).build());
    private static final EnumMap<Schema.Type, JsonToken> SCHEMA_TO_JSON_TYPE = new EnumMap(ImmutableMap.builder().put((Object)Schema.Type.NULL, (Object)JsonToken.NULL).put((Object)Schema.Type.BOOLEAN, (Object)JsonToken.BOOLEAN).put((Object)Schema.Type.INT, (Object)JsonToken.NUMBER).put((Object)Schema.Type.LONG, (Object)JsonToken.NUMBER).put((Object)Schema.Type.FLOAT, (Object)JsonToken.NUMBER).put((Object)Schema.Type.DOUBLE, (Object)JsonToken.NUMBER).put((Object)Schema.Type.STRING, (Object)JsonToken.STRING).put((Object)Schema.Type.BYTES, (Object)JsonToken.BEGIN_ARRAY).put((Object)Schema.Type.ARRAY, (Object)JsonToken.BEGIN_ARRAY).put((Object)Schema.Type.MAP, (Object)JsonToken.BEGIN_OBJECT).put((Object)Schema.Type.RECORD, (Object)JsonToken.BEGIN_OBJECT).build());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toJsonString(StructuredRecord record) throws IOException {
        StringWriter strWriter = new StringWriter();
        try (JsonWriter writer = new JsonWriter((Writer)strWriter);){
            StructuredRecordStringConverter.writeJson(writer, record.getSchema(), record);
            String string = strWriter.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StructuredRecord fromJsonString(String json, Schema schema) throws IOException {
        try (JsonReader reader = new JsonReader((Reader)new StringReader(json));){
            StructuredRecord structuredRecord = (StructuredRecord)StructuredRecordStringConverter.readJson(reader, schema);
            return structuredRecord;
        }
    }

    public static String toDelimitedString(final StructuredRecord record, String delimiter) {
        return Joiner.on((String)delimiter).join(Iterables.transform((Iterable)record.getSchema().getFields(), (Function)new Function<Schema.Field, String>(){

            public String apply(Schema.Field field) {
                return record.get(field.getName()).toString();
            }
        }));
    }

    public static StructuredRecord fromDelimitedString(String delimitedString, String delimiter, Schema schema) {
        StructuredRecord.Builder builder = StructuredRecord.builder((Schema)schema);
        Iterator fields = schema.getFields().iterator();
        for (String part : Splitter.on((String)delimiter).split((CharSequence)delimitedString)) {
            if (part.isEmpty()) continue;
            builder.convertAndSet(((Schema.Field)fields.next()).getName(), part);
        }
        return builder.build();
    }

    private static Object readJson(JsonReader reader, Schema schema) throws IOException {
        switch (schema.getType()) {
            case NULL: {
                reader.nextNull();
                return null;
            }
            case BOOLEAN: {
                return reader.nextBoolean();
            }
            case INT: {
                return reader.nextInt();
            }
            case LONG: {
                return reader.nextLong();
            }
            case FLOAT: {
                return Float.valueOf((float)reader.nextDouble());
            }
            case DOUBLE: {
                return reader.nextDouble();
            }
            case BYTES: {
                return StructuredRecordStringConverter.readBytes(reader);
            }
            case STRING: {
                return reader.nextString();
            }
            case ENUM: {
                return reader.nextString();
            }
            case ARRAY: {
                return StructuredRecordStringConverter.readArray(reader, schema.getComponentSchema());
            }
            case MAP: {
                return StructuredRecordStringConverter.readMap(reader, schema.getMapSchema());
            }
            case RECORD: {
                return StructuredRecordStringConverter.readRecord(reader, schema);
            }
            case UNION: {
                return StructuredRecordStringConverter.readUnion(reader, schema);
            }
        }
        throw new IOException("Unsupported schema: " + schema);
    }

    private static byte[] readBytes(JsonReader reader) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(128);
        reader.beginArray();
        while (reader.peek() != JsonToken.END_ARRAY) {
            os.write(reader.nextInt());
        }
        reader.endArray();
        return os.toByteArray();
    }

    private static List<Object> readArray(JsonReader reader, Schema elementSchema) throws IOException {
        ArrayList<Object> result = new ArrayList<Object>();
        reader.beginArray();
        while (reader.peek() != JsonToken.END_ARRAY) {
            result.add(StructuredRecordStringConverter.readJson(reader, elementSchema));
        }
        reader.endArray();
        return result;
    }

    private static Map<Object, Object> readMap(JsonReader reader, Map.Entry<Schema, Schema> mapSchema) throws IOException {
        Schema keySchema = mapSchema.getKey();
        if (!keySchema.isCompatible(Schema.of((Schema.Type)Schema.Type.STRING))) {
            throw new IOException("Complex key type not supported: " + keySchema);
        }
        Schema valueSchema = mapSchema.getValue();
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        reader.beginObject();
        while (reader.peek() != JsonToken.END_OBJECT) {
            Object key = StructuredRecordStringConverter.convertKey(reader.nextName(), keySchema.getType());
            result.put(key, StructuredRecordStringConverter.readJson(reader, valueSchema));
        }
        reader.endObject();
        return result;
    }

    private static Object convertKey(String key, Schema.Type type) throws IOException {
        switch (type) {
            case STRING: {
                return key;
            }
            case BOOLEAN: {
                return Boolean.valueOf(key);
            }
            case INT: {
                return Integer.valueOf(key);
            }
            case LONG: {
                return Long.valueOf(key);
            }
            case FLOAT: {
                return Float.valueOf(key);
            }
            case DOUBLE: {
                return Double.valueOf(key);
            }
        }
        throw new IOException("Unable to convert string to type " + type);
    }

    private static StructuredRecord readRecord(JsonReader reader, Schema schema) throws IOException {
        StructuredRecord.Builder builder = StructuredRecord.builder((Schema)schema);
        reader.beginObject();
        while (reader.peek() != JsonToken.END_OBJECT) {
            Schema.Field field = schema.getField(reader.nextName());
            if (field == null) {
                reader.skipValue();
                continue;
            }
            builder.set(field.getName(), StructuredRecordStringConverter.readJson(reader, field.getSchema()));
        }
        reader.endObject();
        return builder.build();
    }

    private static Object readUnion(JsonReader reader, Schema unionSchema) throws IOException {
        JsonToken token = reader.peek();
        for (Schema schema : unionSchema.getUnionSchemas()) {
            if (SCHEMA_TO_JSON_TYPE.get(schema.getType()) != token) continue;
            return StructuredRecordStringConverter.readJson(reader, schema);
        }
        throw new IOException("No matching schema found for union type: " + unionSchema);
    }

    private static void writeJson(JsonWriter writer, Schema schema, Object value) throws IOException {
        switch (schema.getType()) {
            case NULL: {
                writer.nullValue();
                break;
            }
            case BOOLEAN: {
                writer.value(((Boolean)value).booleanValue());
                break;
            }
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                writer.value((Number)value);
                break;
            }
            case BYTES: {
                StructuredRecordStringConverter.writeBytes(writer, value);
                break;
            }
            case STRING: {
                writer.value((String)value);
                break;
            }
            case ENUM: {
                writer.value(((Enum)value).name());
                break;
            }
            case ARRAY: {
                StructuredRecordStringConverter.writeArray(writer, schema.getComponentSchema(), value);
                break;
            }
            case MAP: {
                StructuredRecordStringConverter.writeMap(writer, schema.getMapSchema(), value);
                break;
            }
            case RECORD: {
                StructuredRecordStringConverter.writeRecord(writer, schema, value);
                break;
            }
            case UNION: {
                StructuredRecordStringConverter.writeJson(writer, StructuredRecordStringConverter.findUnionSchema(schema, value), value);
            }
        }
    }

    private static void writeBytes(JsonWriter writer, Object value) throws IOException {
        if (value instanceof ByteBuffer) {
            StructuredRecordStringConverter.writeBytes(writer, (ByteBuffer)value);
        } else if (value.getClass().isArray() && value.getClass().getComponentType().equals(Byte.TYPE)) {
            byte[] bytes = (byte[])value;
            StructuredRecordStringConverter.writeBytes(writer, bytes, 0, bytes.length);
        } else {
            throw new IOException("Expects either ByteBuffer or byte[]. Got " + value.getClass());
        }
    }

    private static void writeBytes(JsonWriter writer, ByteBuffer buffer) throws IOException {
        if (buffer.hasArray()) {
            StructuredRecordStringConverter.writeBytes(writer, buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        } else {
            byte[] buf = Bytes.getBytes((ByteBuffer)buffer);
            buffer.mark();
            buffer.get(buf);
            buffer.reset();
            StructuredRecordStringConverter.writeBytes(writer, buf, 0, buf.length);
        }
    }

    private static void writeBytes(JsonWriter writer, byte[] bytes, int off, int len) throws IOException {
        writer.beginArray();
        for (int i = off; i < off + len; ++i) {
            writer.value((long)bytes[i]);
        }
        writer.endArray();
    }

    private static void writeArray(JsonWriter writer, Schema elementSchema, Object value) throws IOException {
        if (!(value instanceof Collection) && !value.getClass().isArray()) {
            throw new IOException("Expects either Collection or array. Got: " + value.getClass());
        }
        writer.beginArray();
        if (value instanceof Collection) {
            for (Object element : (Collection)value) {
                StructuredRecordStringConverter.writeJson(writer, elementSchema, element);
            }
        } else {
            Object[] array;
            for (Object anArray : array = (Object[])value) {
                StructuredRecordStringConverter.writeJson(writer, elementSchema, anArray);
            }
        }
        writer.endArray();
    }

    private static void writeMap(JsonWriter writer, Map.Entry<Schema, Schema> entrySchema, Object value) throws IOException {
        if (!(value instanceof Map)) {
            throw new IOException("Expects Map. Got: " + value.getClass());
        }
        Schema keySchema = entrySchema.getKey();
        if (!keySchema.isCompatible(Schema.of((Schema.Type)Schema.Type.STRING))) {
            throw new IOException("Complex key type not supported: " + keySchema);
        }
        Schema valueSchema = entrySchema.getValue();
        writer.beginObject();
        for (Map.Entry entry : ((Map)value).entrySet()) {
            writer.name(entry.getKey().toString());
            StructuredRecordStringConverter.writeJson(writer, valueSchema, entry.getValue());
        }
        writer.endObject();
    }

    private static void writeRecord(JsonWriter writer, Schema schema, Object value) throws IOException {
        if (!(value instanceof StructuredRecord)) {
            throw new IOException("Expects StructuredRecord. Got: " + value.getClass());
        }
        StructuredRecord record = (StructuredRecord)value;
        writer.beginObject();
        for (Schema.Field field : schema.getFields()) {
            Object fieldValue = record.get(field.getName());
            if (fieldValue == null) continue;
            writer.name(field.getName());
            StructuredRecordStringConverter.writeJson(writer, field.getSchema(), fieldValue);
        }
        writer.endObject();
    }

    private static Schema findUnionSchema(Schema unionSchema, @Nullable Object value) throws IOException {
        Schema.Type type = StructuredRecordStringConverter.getSchemaType(value);
        for (Schema schema : unionSchema.getUnionSchemas()) {
            if (schema.getType() != type) continue;
            return schema;
        }
        throw new IOException("Value type " + type + " not valid in union: " + unionSchema);
    }

    private static Schema.Type getSchemaType(@Nullable Object value) throws IOException {
        if (value == null) {
            return Schema.Type.NULL;
        }
        Class<?> cls = value.getClass();
        Schema.Type type = TYPE_TO_SCHEMA.get(cls);
        if (type != null) {
            return type;
        }
        if (Collection.class.isAssignableFrom(cls) || cls.isArray()) {
            return Schema.Type.ARRAY;
        }
        if (Map.class.isAssignableFrom(cls)) {
            return Schema.Type.MAP;
        }
        throw new IOException("Unsupported type found in StructuredRecord: " + cls);
    }

    private StructuredRecordStringConverter() {
    }
}

