/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.common;

import co.cask.cdap.api.data.format.StructuredRecord;
import co.cask.cdap.api.data.schema.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public final class RecordWritableConverter {
    public static MapWritable covertToWritable(StructuredRecord record) throws IOException {
        MapWritable result = new MapWritable();
        for (Schema.Field field : record.getSchema().getFields()) {
            try {
                result.put((Writable)new Text(field.getName()), RecordWritableConverter.getWritables(record.get(field.getName()), field.getSchema()));
            }
            catch (Exception e) {
                throw new IOException(String.format("Type exception for field %s: %s", field.getName(), e.getMessage()));
            }
        }
        return result;
    }

    private static Writable getWritables(Object object, Schema schema) throws IOException {
        if (object == null && schema.getType() != Schema.Type.NULL && schema.getType() != Schema.Type.UNION) {
            throw new ClassCastException("This object is null.");
        }
        switch (schema.getType()) {
            case NULL: {
                if (object == null) {
                    return NullWritable.get();
                }
                throw new ClassCastException("This object is not null: " + object.toString());
            }
            case BOOLEAN: {
                return new BooleanWritable(((Boolean)object).booleanValue());
            }
            case INT: {
                return new IntWritable(((Integer)object).intValue());
            }
            case LONG: {
                return new LongWritable(((Long)object).longValue());
            }
            case FLOAT: {
                return new FloatWritable(((Float)object).floatValue());
            }
            case DOUBLE: {
                return new DoubleWritable(((Double)object).doubleValue());
            }
            case BYTES: {
                return new BytesWritable((byte[])object);
            }
            case STRING: {
                return new Text((String)object);
            }
            case ENUM: {
                return new Text((String)object);
            }
            case ARRAY: {
                return RecordWritableConverter.convertFromArray((ArrayList)object, schema.getComponentSchema());
            }
            case MAP: {
                return RecordWritableConverter.convertFromMap((Map)object, schema.getMapSchema());
            }
            case RECORD: {
                return RecordWritableConverter.covertToWritable((StructuredRecord)object);
            }
            case UNION: {
                return RecordWritableConverter.convertFromUnion(object, schema.getUnionSchemas());
            }
        }
        throw new IOException("Unsupported schema: " + schema.getType());
    }

    private static ArrayWritable convertFromArray(ArrayList list, Schema schema) throws IOException {
        Writable[] writableArray = new Writable[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            writableArray[i] = RecordWritableConverter.getWritables(list.get(i), schema);
        }
        return new ArrayWritable(Writable.class, writableArray);
    }

    private static Writable convertFromUnion(Object object, List<Schema> schemas) throws IOException {
        for (Schema schema : schemas) {
            try {
                return RecordWritableConverter.getWritables(object, schema);
            }
            catch (Exception e) {
            }
        }
        throw new IOException("Object " + object.toString() + " is not of correct type");
    }

    private static MapWritable convertFromMap(Map map, Map.Entry<Schema, Schema> schemaMap) throws IOException {
        MapWritable mapWritable = new MapWritable();
        for (Object key : map.keySet()) {
            mapWritable.put(RecordWritableConverter.getWritables(key, schemaMap.getKey()), RecordWritableConverter.getWritables(map.get(key), schemaMap.getValue()));
        }
        return mapWritable;
    }

    public static StructuredRecord convertToRecord(MapWritable input, Schema schema) throws IOException {
        StructuredRecord.Builder builder = StructuredRecord.builder((Schema)schema);
        for (Schema.Field field : schema.getFields()) {
            try {
                builder.set(field.getName(), RecordWritableConverter.convertWritables(input.get((Object)new Text(field.getName())), field.getSchema()));
            }
            catch (Exception e) {
                throw new IOException(String.format("Type exception for field %s: %s", field.getName(), e.getMessage()));
            }
        }
        return builder.build();
    }

    private static Object convertWritables(Writable writable, Schema schema) throws IOException {
        if (writable.getClass() == NullWritable.class && schema.getType() != Schema.Type.NULL && schema.getType() != Schema.Type.UNION) {
            throw new ClassCastException("This field is null.");
        }
        switch (schema.getType()) {
            case NULL: {
                if (writable.getClass() == NullWritable.class) {
                    return null;
                }
                throw new ClassCastException("This field is not null:" + writable.toString());
            }
            case BOOLEAN: {
                return ((BooleanWritable)writable).get();
            }
            case INT: {
                return (int)(writable.getClass() == IntWritable.class ? (long)((IntWritable)writable).get() : ((LongWritable)writable).get());
            }
            case LONG: {
                return ((LongWritable)writable).get();
            }
            case FLOAT: {
                return Float.valueOf((float)(writable.getClass() == FloatWritable.class ? (double)((FloatWritable)writable).get() : ((DoubleWritable)writable).get()));
            }
            case DOUBLE: {
                return ((DoubleWritable)writable).get();
            }
            case BYTES: {
                return ((BytesWritable)writable).getBytes();
            }
            case STRING: {
                return writable.toString();
            }
            case ENUM: {
                return writable.toString();
            }
            case ARRAY: {
                return RecordWritableConverter.convertArray((ArrayWritable)writable, schema.getComponentSchema());
            }
            case MAP: {
                return RecordWritableConverter.convertMap((MapWritable)writable, schema.getMapSchema());
            }
            case RECORD: {
                return RecordWritableConverter.convertToRecord((MapWritable)writable, schema);
            }
            case UNION: {
                return RecordWritableConverter.convertUnion(writable, schema);
            }
        }
        throw new IOException("Unsupported schema: " + schema);
    }

    private static List<Object> convertArray(ArrayWritable input, Schema elementSchema) throws IOException {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Writable writable : input.get()) {
            result.add(RecordWritableConverter.convertWritables(writable, elementSchema));
        }
        return result;
    }

    private static Map<Object, Object> convertMap(MapWritable input, Map.Entry<Schema, Schema> mapSchema) throws IOException {
        Schema keySchema = mapSchema.getKey();
        if (!keySchema.isCompatible(Schema.of((Schema.Type)Schema.Type.STRING))) {
            throw new IOException("Complex key type not supported: " + keySchema);
        }
        Schema valueSchema = mapSchema.getValue();
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (Writable key : input.keySet()) {
            result.put(RecordWritableConverter.convertWritables(key, keySchema), RecordWritableConverter.convertWritables(input.get((Object)key), valueSchema));
        }
        return result;
    }

    private static Object convertUnion(Writable input, Schema unionSchema) throws IOException {
        for (Schema schema : unionSchema.getUnionSchemas()) {
            try {
                return RecordWritableConverter.convertWritables(input, schema);
            }
            catch (ClassCastException e) {
            }
        }
        throw new IOException("No matching schema found for union type: " + unionSchema);
    }

    private RecordWritableConverter() {
    }
}

