/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.common;

import co.cask.cdap.api.common.Bytes;
import co.cask.cdap.api.data.format.StructuredRecord;
import co.cask.cdap.api.data.schema.Schema;
import co.cask.cdap.api.dataset.table.Put;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public class RecordPutTransformer {
    private final String rowField;
    private final Schema outputSchema;

    @VisibleForTesting
    RecordPutTransformer(String rowField) {
        this(rowField, null);
    }

    public RecordPutTransformer(String rowField, Schema outputSchema) {
        this.rowField = rowField;
        this.outputSchema = outputSchema;
    }

    public Put toPut(StructuredRecord record) {
        Schema recordSchema = record.getSchema();
        Preconditions.checkArgument((recordSchema.getType() == Schema.Type.RECORD ? 1 : 0) != 0, (Object)"input must be a record.");
        Schema.Field keyField = this.getKeyField(recordSchema);
        Preconditions.checkArgument((keyField != null ? 1 : 0) != 0, (Object)"Could not find key field in record.");
        Put output = this.createPut(record, keyField);
        for (Schema.Field field : recordSchema.getFields()) {
            if (field.getName().equals(keyField.getName()) || this.outputSchema != null && this.outputSchema.getField(field.getName()) == null) continue;
            this.setField(output, field, record.get(field.getName()));
        }
        return output;
    }

    private void setField(Put put, Schema.Field field, Object val) {
        if (field.getSchema().isNullable() && val == null) {
            put.add(field.getName(), (byte[])null);
            return;
        }
        Schema.Type type = this.validateAndGetType(field);
        switch (type) {
            case BOOLEAN: {
                put.add(field.getName(), ((Boolean)val).booleanValue());
                break;
            }
            case INT: {
                put.add(field.getName(), ((Integer)val).intValue());
                break;
            }
            case LONG: {
                put.add(field.getName(), ((Long)val).longValue());
                break;
            }
            case FLOAT: {
                put.add(field.getName(), ((Float)val).floatValue());
                break;
            }
            case DOUBLE: {
                put.add(field.getName(), ((Double)val).doubleValue());
                break;
            }
            case BYTES: {
                if (val instanceof ByteBuffer) {
                    put.add(field.getName(), Bytes.toBytes((ByteBuffer)((ByteBuffer)val)));
                    break;
                }
                put.add(field.getName(), (byte[])val);
                break;
            }
            case STRING: {
                put.add(field.getName(), (String)val);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + field.getName() + " is of unsupported type " + type);
            }
        }
    }

    private Schema.Type validateAndGetType(Schema.Field field) {
        Schema.Type type = field.getSchema().isNullable() ? field.getSchema().getNonNullable().getType() : field.getSchema().getType();
        Preconditions.checkArgument((boolean)type.isSimpleType(), (Object)"only simple types are supported (boolean, int, long, float, double, bytes).");
        return type;
    }

    private Put createPut(StructuredRecord record, Schema.Field keyField) {
        String keyFieldName = keyField.getName();
        Object val = record.get(keyFieldName);
        Preconditions.checkArgument((val != null ? 1 : 0) != 0, (Object)"Row key cannot be null.");
        Schema.Type keyType = this.validateAndGetType(keyField);
        switch (keyType) {
            case BOOLEAN: {
                return new Put(Bytes.toBytes((boolean)((Boolean)val)));
            }
            case INT: {
                return new Put(Bytes.toBytes((int)((Integer)val)));
            }
            case LONG: {
                return new Put(Bytes.toBytes((long)((Long)val)));
            }
            case FLOAT: {
                return new Put(Bytes.toBytes((float)((Float)val).floatValue()));
            }
            case DOUBLE: {
                return new Put(Bytes.toBytes((double)((Double)val)));
            }
            case BYTES: {
                if (val instanceof ByteBuffer) {
                    return new Put(Bytes.toBytes((ByteBuffer)((ByteBuffer)val)));
                }
                return new Put((byte[])val);
            }
            case STRING: {
                return new Put(Bytes.toBytes((String)((String)record.get(keyFieldName))));
            }
        }
        throw new IllegalArgumentException("Row key is of unsupported type " + keyType);
    }

    @Nullable
    private Schema.Field getKeyField(Schema recordSchema) {
        return recordSchema.getField(this.rowField);
    }
}

