/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.util.concurrent.TimeUnit;

public final class ETLUtils {
    public static long parseDuration(String durationStr) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)durationStr) ? 1 : 0) != 0);
        durationStr = durationStr.toLowerCase();
        String value = durationStr.substring(0, durationStr.length() - 1);
        int parsedValue = 0;
        try {
            parsedValue = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            Throwables.propagate((Throwable)nfe);
        }
        Preconditions.checkArgument((parsedValue >= 0 ? 1 : 0) != 0);
        char lastChar = durationStr.charAt(durationStr.length() - 1);
        switch (lastChar) {
            case 's': {
                return TimeUnit.SECONDS.toMillis(parsedValue);
            }
            case 'm': {
                return TimeUnit.MINUTES.toMillis(parsedValue);
            }
            case 'h': {
                return TimeUnit.HOURS.toMillis(parsedValue);
            }
            case 'd': {
                return TimeUnit.DAYS.toMillis(parsedValue);
            }
        }
        throw new IllegalArgumentException(String.format("Time unit not supported: %s", Character.valueOf(lastChar)));
    }

    private ETLUtils() {
        throw new AssertionError((Object)"Suppress default constructor for non-instantiability");
    }
}

