/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.template.etl.batch;

import co.cask.cdap.api.data.DatasetInstantiationException;
import co.cask.cdap.api.dataset.Dataset;
import co.cask.cdap.api.mapreduce.MapReduceContext;
import co.cask.cdap.api.metrics.Metrics;
import co.cask.cdap.api.templates.AdapterSpecification;
import co.cask.cdap.api.templates.plugins.PluginProperties;
import co.cask.cdap.template.etl.api.batch.BatchContext;
import co.cask.cdap.template.etl.batch.BatchTransformContext;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class MapReduceBatchContext
extends BatchTransformContext
implements BatchContext {
    protected final MapReduceContext mrContext;

    public MapReduceBatchContext(MapReduceContext context, Metrics metrics, String prefixId) {
        super(context, metrics, prefixId);
        this.mrContext = context;
    }

    @Override
    public long getLogicalStartTime() {
        return this.mrContext.getLogicalStartTime();
    }

    @Override
    public <T> T getHadoopJob() {
        return (T)this.mrContext.getHadoopJob();
    }

    public <T extends Dataset> T getDataset(String name) throws DatasetInstantiationException {
        return (T)this.mrContext.getDataset(name);
    }

    public <T extends Dataset> T getDataset(String name, Map<String, String> arguments) throws DatasetInstantiationException {
        return (T)this.mrContext.getDataset(name, arguments);
    }

    @Nullable
    public AdapterSpecification getAdapterSpecification() {
        return this.mrContext.getAdapterSpecification();
    }

    public PluginProperties getPluginProperties(String pluginId) {
        return this.mrContext.getPluginProperties(this.getPluginId(pluginId));
    }

    public <T> Class<T> loadPluginClass(String pluginId) {
        return this.mrContext.loadPluginClass(this.getPluginId(pluginId));
    }

    public <T> T newPluginInstance(String pluginId) throws InstantiationException {
        return (T)this.mrContext.newPluginInstance(this.getPluginId(pluginId));
    }

    private String getPluginId(String childPluginId) {
        return String.format("%s%s%s", this.pluginPrefix, ":", childPluginId);
    }
}

