/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.template.etl.batch;

import co.cask.cdap.api.app.ApplicationConfigurer;
import co.cask.cdap.api.app.ApplicationContext;
import co.cask.cdap.api.mapreduce.MapReduce;
import co.cask.cdap.api.schedule.Schedule;
import co.cask.cdap.api.templates.AdapterConfigurer;
import co.cask.cdap.api.workflow.Workflow;
import co.cask.cdap.internal.schedule.TimeSchedule;
import co.cask.cdap.template.etl.batch.ETLMapReduce;
import co.cask.cdap.template.etl.batch.ETLWorkflow;
import co.cask.cdap.template.etl.batch.config.ETLBatchConfig;
import co.cask.cdap.template.etl.common.ETLConfig;
import co.cask.cdap.template.etl.common.ETLTemplate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ETLBatchTemplate
extends ETLTemplate<ETLBatchConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(ETLBatchTemplate.class);
    private static final Gson GSON = new Gson();

    public void configureAdapter(String adapterName, ETLBatchConfig etlBatchConfig, AdapterConfigurer configurer) throws Exception {
        super.configureAdapter(adapterName, (ETLConfig)etlBatchConfig, configurer);
        String scheduleStr = etlBatchConfig.getSchedule();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)scheduleStr) ? 1 : 0) != 0, (Object)"Schedule must be specified in the config.");
        configurer.addRuntimeArgument("config", GSON.toJson((Object)etlBatchConfig));
        configurer.setSchedule((Schedule)new TimeSchedule(String.format("etl.batch.adapter.%s.schedule", adapterName), String.format("Schedule for %s Adapter", adapterName), etlBatchConfig.getSchedule()));
    }

    public void configure(ApplicationConfigurer configurer, ApplicationContext context) {
        configurer.setName(this.getAppName("etl.batch.plugin.name"));
        configurer.setDescription("Batch Extract-Transform-Load (ETL) Template");
        configurer.addMapReduce((MapReduce)new ETLMapReduce());
        configurer.addWorkflow((Workflow)new ETLWorkflow());
    }
}

