/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.api.lookup;

import co.cask.cdap.api.common.Bytes;
import co.cask.cdap.api.dataset.table.Row;
import co.cask.cdap.api.dataset.table.Table;
import co.cask.cdap.etl.api.Lookup;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TableLookup
implements Lookup<Row> {
    private final Table table;

    public TableLookup(Table table) {
        this.table = table;
    }

    @Override
    public Row lookup(String key) {
        return this.table.get(Bytes.toBytes((String)key));
    }

    @Override
    public Map<String, Row> lookup(String ... keys) {
        return this.lookup((Set<String>)ImmutableSet.copyOf((Object[])keys));
    }

    @Override
    public Map<String, Row> lookup(Set<String> keys) {
        HashMap<String, Row> results = new HashMap<String, Row>();
        for (String key : keys) {
            results.put(key, this.lookup(key));
        }
        return results;
    }
}

