/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.api.lineage.field;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.api.lineage.field.EndPoint;
import co.cask.cdap.etl.api.lineage.field.FieldOperation;
import co.cask.cdap.etl.api.lineage.field.OperationType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Beta
public class FieldWriteOperation
extends FieldOperation {
    private final List<String> inputFields;
    private final EndPoint sink;

    public FieldWriteOperation(String name, String description, EndPoint sink, String ... inputFields) {
        this(name, description, sink, Arrays.asList(inputFields));
    }

    public FieldWriteOperation(String name, String description, EndPoint sink, List<String> inputFields) {
        super(name, OperationType.WRITE, description);
        this.sink = sink;
        this.inputFields = Collections.unmodifiableList(new ArrayList<String>(inputFields));
    }

    public EndPoint getSink() {
        return this.sink;
    }

    public List<String> getInputFields() {
        return this.inputFields;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FieldWriteOperation that = (FieldWriteOperation)o;
        return Objects.equals(this.inputFields, that.inputFields) && Objects.equals(this.sink, that.sink);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.inputFields, this.sink);
    }
}

