/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.api.lineage.field;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.etl.api.lineage.field.FieldOperation;
import co.cask.cdap.etl.api.lineage.field.OperationType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Beta
public class FieldTransformOperation
extends FieldOperation {
    private final List<String> inputFields;
    private final List<String> outputFields;

    public FieldTransformOperation(String name, String description, List<String> inputFields, String ... outputFields) {
        this(name, description, inputFields, Arrays.asList(outputFields));
    }

    public FieldTransformOperation(String name, String description, List<String> inputFields, List<String> outputFields) {
        super(name, OperationType.TRANSFORM, description);
        this.inputFields = Collections.unmodifiableList(new ArrayList<String>(inputFields));
        this.outputFields = Collections.unmodifiableList(new ArrayList<String>(outputFields));
    }

    public List<String> getInputFields() {
        return this.inputFields;
    }

    public List<String> getOutputFields() {
        return this.outputFields;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FieldTransformOperation that = (FieldTransformOperation)o;
        return Objects.equals(this.inputFields, that.inputFields) && Objects.equals(this.outputFields, that.outputFields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.inputFields, this.outputFields);
    }
}

