/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.api.lineage.field;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.api.lineage.field.EndPoint;
import co.cask.cdap.etl.api.lineage.field.FieldOperation;
import co.cask.cdap.etl.api.lineage.field.OperationType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Beta
public class FieldReadOperation
extends FieldOperation {
    private final EndPoint source;
    private final List<String> outputFields;

    public FieldReadOperation(String name, String description, EndPoint source, String ... outputFields) {
        this(name, description, source, Arrays.asList(outputFields));
    }

    public FieldReadOperation(String name, String description, EndPoint source, List<String> outputFields) {
        super(name, OperationType.READ, description);
        this.source = source;
        this.outputFields = Collections.unmodifiableList(new ArrayList<String>(outputFields));
    }

    public EndPoint getSource() {
        return this.source;
    }

    public List<String> getOutputFields() {
        return this.outputFields;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FieldReadOperation that = (FieldReadOperation)o;
        return Objects.equals(this.source, that.source) && Objects.equals(this.outputFields, that.outputFields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.source, this.outputFields);
    }
}

