/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.etl.api.lookup;

import co.cask.cdap.api.common.Bytes;
import co.cask.cdap.api.dataset.lib.KeyValueTable;
import co.cask.cdap.etl.api.Lookup;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class KeyValueTableLookup
implements Lookup<String> {
    private final KeyValueTable table;

    public KeyValueTableLookup(KeyValueTable table) {
        this.table = table;
    }

    @Override
    public String lookup(String key) {
        return Bytes.toString((byte[])this.table.read(key));
    }

    @Override
    public Map<String, String> lookup(String ... keys) {
        return this.lookup((Set<String>)ImmutableSet.copyOf((Object[])keys));
    }

    @Override
    public Map<String, String> lookup(Set<String> keys) {
        return this.fromBytes(this.table.readAll(this.toBytes(keys)));
    }

    private Map<String, String> fromBytes(Map<byte[], byte[]> bytes) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<byte[], byte[]> entry : bytes.entrySet()) {
            result.put(Bytes.toString((byte[])entry.getKey()), Bytes.toString((byte[])entry.getValue()));
        }
        return result;
    }

    private byte[][] toBytes(Set<String> keys) {
        byte[][] result = new byte[keys.size()][];
        int i = 0;
        for (String key : keys) {
            result[i++] = Bytes.toBytes((String)key);
        }
        return result;
    }
}

