/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.docgen.client;

import co.cask.cdap.api.flow.flowlet.StreamEvent;
import co.cask.cdap.api.metrics.RuntimeMetrics;
import co.cask.cdap.api.service.ServiceSpecification;
import co.cask.cdap.client.ApplicationClient;
import co.cask.cdap.client.DatasetClient;
import co.cask.cdap.client.DatasetModuleClient;
import co.cask.cdap.client.DatasetTypeClient;
import co.cask.cdap.client.MetricsClient;
import co.cask.cdap.client.MonitorClient;
import co.cask.cdap.client.PreferencesClient;
import co.cask.cdap.client.ProgramClient;
import co.cask.cdap.client.QueryClient;
import co.cask.cdap.client.ServiceClient;
import co.cask.cdap.client.StreamClient;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.explore.client.ExploreExecutionResult;
import co.cask.cdap.proto.ColumnDesc;
import co.cask.cdap.proto.DatasetModuleMeta;
import co.cask.cdap.proto.DatasetTypeMeta;
import co.cask.cdap.proto.StreamProperties;
import co.cask.cdap.proto.id.ApplicationId;
import co.cask.cdap.proto.id.DatasetId;
import co.cask.cdap.proto.id.DatasetModuleId;
import co.cask.cdap.proto.id.NamespaceId;
import co.cask.cdap.proto.id.ProgramId;
import co.cask.cdap.proto.id.StreamId;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenerateClientUsageExample {
    private final ClientConfig clientConfig = null;

    public void applicationClient() throws Exception {
        ApplicationClient appClient = new ApplicationClient(this.clientConfig);
        List apps = appClient.list(NamespaceId.DEFAULT);
        File appJarFile = new File("your-app.jar");
        appClient.deploy(NamespaceId.DEFAULT, appJarFile);
        appClient.delete(NamespaceId.DEFAULT.app("Purchase"));
        appClient.listPrograms(NamespaceId.DEFAULT.app("Purchase"));
    }

    public void preferencesClient() throws Exception {
        PreferencesClient preferencesClient = new PreferencesClient(this.clientConfig);
        HashMap propMap = Maps.newHashMap();
        propMap.put("k1", "v1");
        preferencesClient.setInstancePreferences((Map)propMap);
        preferencesClient.getInstancePreferences();
        preferencesClient.deleteInstancePreferences();
        preferencesClient.setApplicationPreferences(new ApplicationId("Dev", "MyApp"), (Map)propMap);
        Map appPrefs = preferencesClient.getApplicationPreferences(new ApplicationId("Dev", "MyApp"), false);
        Map resolvedAppPrefs = preferencesClient.getApplicationPreferences(new ApplicationId("Dev", "MyApp"), true);
    }

    public void programClient() throws Exception {
        ProgramClient programClient = new ProgramClient(this.clientConfig);
        programClient.start((ProgramId)NamespaceId.DEFAULT.app("WordCount").service("RetrieveCounts"));
        programClient.getLiveInfo((ProgramId)NamespaceId.DEFAULT.app("HelloWorld").service("greet"));
        programClient.getProgramLogs((ProgramId)NamespaceId.DEFAULT.app("WordCount").service("RetrieveCounts"), 0L, Long.MAX_VALUE);
        programClient.setServiceInstances(NamespaceId.DEFAULT.app("HelloWorld").service("greet"), 3);
        programClient.stop((ProgramId)NamespaceId.DEFAULT.app("HelloWorld").service("greet"));
        programClient.start((ProgramId)NamespaceId.DEFAULT.app("WordCount").flow("WordCountFlow"));
        programClient.getAllProgramRuns((ProgramId)NamespaceId.DEFAULT.app("WordCount").flow("WordCountFlow"), 0L, Long.MAX_VALUE, 10);
        programClient.setFlowletInstances(NamespaceId.DEFAULT.app("WordCount").flow("WordCountFlow").flowlet("Tokenizer"), 3);
        programClient.stop((ProgramId)NamespaceId.DEFAULT.app("WordCount").flow("WordCountFlow"));
    }

    public void streamClient() throws Exception {
        StreamClient streamClient = new StreamClient(this.clientConfig);
        List streams = streamClient.list(NamespaceId.DEFAULT);
        StreamId streamId = NamespaceId.DEFAULT.stream("purchases");
        streamClient.create(streamId);
        StreamProperties config = streamClient.getConfig(streamId);
        streamClient.sendEvent(streamId, "Tom bought 5 apples for $10");
        ArrayList events = Lists.newArrayList();
        streamClient.getEvents(streamId, 0L, Long.MAX_VALUE, Integer.MAX_VALUE, (Collection)events);
        events = Lists.newArrayList();
        streamClient.getEvents(streamId, 0L, Long.MAX_VALUE, 5, (Collection)events);
        long startTime = ((StreamEvent)events.get(1)).getTimestamp();
        long endTime = ((StreamEvent)events.get(2)).getTimestamp() + 1L;
        events.clear();
        streamClient.getEvents(streamId, startTime, endTime, Integer.MAX_VALUE, (Collection)events);
        streamId = NamespaceId.DEFAULT.stream("testAsync");
        events = Lists.newArrayList();
        streamClient.create(streamId);
        int msgCount = 10;
        for (int i = 0; i < msgCount; ++i) {
            streamClient.asyncSendEvent(streamId, "Testing " + i);
        }
        while (events.size() != msgCount) {
            events.clear();
            streamClient.getEvents(streamId, 0L, Long.MAX_VALUE, msgCount, (Collection)events);
        }
        events.clear();
        while (events.isEmpty()) {
            events.clear();
            streamClient.getEvents(streamId, 0L, Long.MAX_VALUE, msgCount, (Collection)events);
        }
    }

    public void datasetClient() throws Exception {
        DatasetClient datasetClient = new DatasetClient(this.clientConfig);
        List datasets = datasetClient.list(NamespaceId.DEFAULT);
        DatasetId datasetId = NamespaceId.DEFAULT.dataset("someDataset");
        datasetClient.create(datasetId, "someDatasetType");
        datasetClient.truncate(datasetId);
        datasetClient.delete(datasetId);
    }

    public void datasetModuleClient() throws Exception {
        DatasetModuleClient datasetModuleClient = new DatasetModuleClient(this.clientConfig);
        File moduleJarFile = this.createAppJarFile(SomeDatasetModule.class);
        DatasetModuleId datasetModuleId = NamespaceId.DEFAULT.datasetModule("someDatasetModule");
        datasetModuleClient.add(datasetModuleId, SomeDatasetModule.class.getName(), moduleJarFile);
        DatasetModuleMeta datasetModuleMeta = datasetModuleClient.get(datasetModuleId);
        datasetModuleClient.deleteAll(NamespaceId.DEFAULT);
    }

    public void datasetTypeClient() throws Exception {
        DatasetTypeClient datasetTypeClient = new DatasetTypeClient(this.clientConfig);
        DatasetTypeMeta datasetTypeMeta = datasetTypeClient.get(NamespaceId.DEFAULT.datasetType("someDatasetType"));
        datasetTypeClient.get(NamespaceId.DEFAULT.datasetType(SomeDataset.class.getName()));
    }

    public void queryClient() throws Exception {
        QueryClient queryClient = new QueryClient(this.clientConfig);
        ListenableFuture resultFuture = queryClient.execute(NamespaceId.DEFAULT, "SELECT * FROM dataset_history WHERE customer IN ('Alice','Bob')");
        ExploreExecutionResult results = (ExploreExecutionResult)resultFuture.get();
        List schema = results.getResultSchema();
        String[] header = new String[schema.size()];
        for (int i = 0; i < header.length; ++i) {
            ColumnDesc column = (ColumnDesc)schema.get(i);
            int index = column.getPosition() - 1;
            header[index] = column.getName() + ": " + column.getType();
        }
    }

    public void serviceClient() throws Exception {
        ServiceClient serviceClient = new ServiceClient(this.clientConfig);
        ServiceSpecification serviceSpec = serviceClient.get((ProgramId)NamespaceId.DEFAULT.app("PurchaseApp").service("CatalogLookup"));
    }

    public void metricsClient() throws Exception {
        MetricsClient metricsClient = new MetricsClient(this.clientConfig);
        RuntimeMetrics metric = metricsClient.getFlowletMetrics(new NamespaceId("user").app("HelloWorld").flow("someFlow").flowlet("process.events.processed"));
    }

    public void monitorClient() throws Exception {
        MonitorClient monitorClient = new MonitorClient(this.clientConfig);
        List services = monitorClient.listSystemServices();
        String serviceStatus = monitorClient.getSystemServiceStatus("transaction");
        int systemServiceInstances = monitorClient.getSystemServiceInstances("transaction");
        monitorClient.setSystemServiceInstances("transaction", 1);
    }

    private File createAppJarFile(Class<?> cls) {
        return null;
    }

    private class SomeDataset {
        private SomeDataset() {
        }
    }

    private class SomeDatasetModule {
        private SomeDatasetModule() {
        }
    }
}

