/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.docgen.cli;

import co.cask.cdap.cli.CommandCategory;
import co.cask.cdap.cli.command.system.HelpCommand;
import co.cask.cdap.cli.util.table.TableRendererConfig;
import co.cask.common.cli.Arguments;
import co.cask.common.cli.Command;
import co.cask.common.cli.CommandSet;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nullable;

public class GenerateCLIDocsTableCommand
extends HelpCommand {
    public GenerateCLIDocsTableCommand(CommandSet commands, TableRendererConfig tableRendererConfig) {
        super(Suppliers.ofInstance((Object)ImmutableList.of((Object)commands)), tableRendererConfig);
    }

    public void execute(Arguments arguments, PrintStream output) throws Exception {
        Multimap categorizedCommands = this.categorizeCommands((Iterable)this.commands.get(), CommandCategory.GENERAL, Predicates.alwaysTrue());
        for (CommandCategory category : CommandCategory.values()) {
            output.printf("   **%s**\n", this.simpleTitleCase(category.getName()));
            ArrayList commandList = Lists.newArrayList((Iterable)categorizedCommands.get((Object)category.getName()));
            Collections.sort(commandList, new Comparator<Command>(){

                @Override
                public int compare(Command command, Command command2) {
                    return command.getPattern().compareTo(command2.getPattern());
                }
            });
            for (Command command : commandList) {
                output.printf("   ``%s``,\"%s\"\n", command.getPattern(), command.getDescription().replace("\"", "\"\""));
            }
        }
    }

    private String simpleTitleCase(String sentence) {
        Iterator transformedWords = Iterators.transform(Splitter.on((String)" ").split((CharSequence)sentence).iterator(), (Function)new Function<String, String>(){

            @Nullable
            public String apply(@Nullable String input) {
                if (input == null) {
                    return null;
                }
                if (input.length() <= 1) {
                    return input.toUpperCase();
                }
                return input.substring(0, 1).toUpperCase() + input.substring(1).toLowerCase();
            }
        });
        return Joiner.on((String)" ").join(transformedWords);
    }

    public String getPattern() {
        return "null";
    }

    public String getDescription() {
        return "null";
    }
}

