/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.docgen.client;

import co.cask.cdap.api.flow.flowlet.StreamEvent;
import co.cask.cdap.api.metrics.RuntimeMetrics;
import co.cask.cdap.api.service.ServiceSpecification;
import co.cask.cdap.client.ApplicationClient;
import co.cask.cdap.client.DatasetClient;
import co.cask.cdap.client.DatasetModuleClient;
import co.cask.cdap.client.DatasetTypeClient;
import co.cask.cdap.client.MetricsClient;
import co.cask.cdap.client.MonitorClient;
import co.cask.cdap.client.PreferencesClient;
import co.cask.cdap.client.ProgramClient;
import co.cask.cdap.client.QueryClient;
import co.cask.cdap.client.ServiceClient;
import co.cask.cdap.client.StreamClient;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.explore.client.ExploreExecutionResult;
import co.cask.cdap.proto.ColumnDesc;
import co.cask.cdap.proto.DatasetModuleMeta;
import co.cask.cdap.proto.DatasetTypeMeta;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.ProgramType;
import co.cask.cdap.proto.StreamProperties;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenerateClientUsageExample {
    private final ClientConfig clientConfig = null;

    public void applicationClient() throws Exception {
        ApplicationClient appClient = new ApplicationClient(this.clientConfig);
        List apps = appClient.list(Id.Namespace.DEFAULT);
        File appJarFile = new File("your-app.jar");
        appClient.deploy(Id.Namespace.DEFAULT, appJarFile);
        appClient.delete(Id.Application.from((Id.Namespace)Id.Namespace.DEFAULT, (String)"Purchase"));
        appClient.listPrograms(Id.Application.from((Id.Namespace)Id.Namespace.DEFAULT, (String)"Purchase"));
    }

    public void preferencesClient() throws Exception {
        PreferencesClient preferencesClient = new PreferencesClient(this.clientConfig);
        HashMap propMap = Maps.newHashMap();
        propMap.put("k1", "v1");
        preferencesClient.setInstancePreferences((Map)propMap);
        Map currentPropMap = preferencesClient.getInstancePreferences();
        preferencesClient.deleteInstancePreferences();
        preferencesClient.setApplicationPreferences(Id.Application.from((String)"Dev", (String)"MyApp"), (Map)propMap);
        Map appPrefs = preferencesClient.getApplicationPreferences(Id.Application.from((String)"Dev", (String)"MyApp"), false);
        Map resolvedAppPrefs = preferencesClient.getApplicationPreferences(Id.Application.from((String)"Dev", (String)"MyApp"), true);
    }

    public void programClient() throws Exception {
        ProgramClient programClient = new ProgramClient(this.clientConfig);
        programClient.start(Id.Program.from((Id.Namespace)Id.Namespace.DEFAULT, (String)"WordCount", (ProgramType)ProgramType.SERVICE, (String)"RetrieveCounts"));
        programClient.getLiveInfo(Id.Program.from((Id.Namespace)Id.Namespace.DEFAULT, (String)"HelloWorld", (ProgramType)ProgramType.SERVICE, (String)"greet"));
        programClient.getProgramLogs(Id.Program.from((Id.Namespace)Id.Namespace.DEFAULT, (String)"WordCount", (ProgramType)ProgramType.SERVICE, (String)"RetrieveCounts"), 0L, Long.MAX_VALUE);
        programClient.setServiceInstances(Id.Service.from((Id.Namespace)Id.Namespace.DEFAULT, (String)"HelloWorld", (String)"greet"), 3);
        programClient.stop(Id.Program.from((Id.Namespace)Id.Namespace.DEFAULT, (String)"HelloWorld", (ProgramType)ProgramType.SERVICE, (String)"greet"));
        programClient.start(Id.Program.from((Id.Namespace)Id.Namespace.DEFAULT, (String)"WordCount", (ProgramType)ProgramType.FLOW, (String)"WordCountFlow"));
        programClient.getAllProgramRuns(Id.Program.from((Id.Namespace)Id.Namespace.DEFAULT, (String)"WordCount", (ProgramType)ProgramType.FLOW, (String)"WordCountFlow"), 0L, Long.MAX_VALUE, 10);
        programClient.setFlowletInstances(Id.Flow.Flowlet.from((Id.Application)Id.Application.from((Id.Namespace)Id.Namespace.DEFAULT, (String)"WordCount"), (String)"WordCountFlow", (String)"Tokenizer"), 3);
        programClient.stop(Id.Program.from((Id.Namespace)Id.Namespace.DEFAULT, (String)"WordCount", (ProgramType)ProgramType.FLOW, (String)"WordCountFlow"));
    }

    public void streamClient() throws Exception {
        StreamClient streamClient = new StreamClient(this.clientConfig);
        List streams = streamClient.list(Id.Namespace.DEFAULT);
        Id.Stream streamId = Id.Stream.from((Id.Namespace)Id.Namespace.DEFAULT, (String)"purchases");
        streamClient.create(streamId);
        StreamProperties config = streamClient.getConfig(streamId);
        streamClient.sendEvent(streamId, "Tom bought 5 apples for $10");
        ArrayList events = Lists.newArrayList();
        streamClient.getEvents(streamId, 0L, Long.MAX_VALUE, Integer.MAX_VALUE, (Collection)events);
        events = Lists.newArrayList();
        streamClient.getEvents(streamId, 0L, Long.MAX_VALUE, 5, (Collection)events);
        long startTime = ((StreamEvent)events.get(1)).getTimestamp();
        long endTime = ((StreamEvent)events.get(2)).getTimestamp() + 1L;
        events.clear();
        streamClient.getEvents(streamId, startTime, endTime, Integer.MAX_VALUE, (Collection)events);
        streamId = Id.Stream.from((Id.Namespace)Id.Namespace.DEFAULT, (String)"testAsync");
        events = Lists.newArrayList();
        streamClient.create(streamId);
        int msgCount = 10;
        for (int i = 0; i < msgCount; ++i) {
            streamClient.asyncSendEvent(streamId, "Testing " + i);
        }
        while (events.size() != msgCount) {
            events.clear();
            streamClient.getEvents(streamId, 0L, Long.MAX_VALUE, msgCount, (Collection)events);
        }
        events.clear();
        while (events.isEmpty()) {
            events.clear();
            streamClient.getEvents(streamId, 0L, Long.MAX_VALUE, msgCount, (Collection)events);
        }
    }

    public void datasetClient() throws Exception {
        DatasetClient datasetClient = new DatasetClient(this.clientConfig);
        List datasets = datasetClient.list(Id.Namespace.DEFAULT);
        Id.DatasetInstance datasetId = Id.DatasetInstance.from((Id.Namespace)Id.Namespace.DEFAULT, (String)"someDataset");
        datasetClient.create(datasetId, "someDatasetType");
        datasetClient.truncate(datasetId);
        datasetClient.delete(datasetId);
    }

    public void datasetModuleClient() throws Exception {
        DatasetModuleClient datasetModuleClient = new DatasetModuleClient(this.clientConfig);
        File moduleJarFile = this.createAppJarFile(SomeDatasetModule.class);
        Id.DatasetModule datasetModuleId = Id.DatasetModule.from((Id.Namespace)Id.Namespace.DEFAULT, (String)"someDatasetModule");
        datasetModuleClient.add(datasetModuleId, SomeDatasetModule.class.getName(), moduleJarFile);
        DatasetModuleMeta datasetModuleMeta = datasetModuleClient.get(datasetModuleId);
        datasetModuleClient.deleteAll(Id.Namespace.DEFAULT);
    }

    public void datasetTypeClient() throws Exception {
        DatasetTypeClient datasetTypeClient = new DatasetTypeClient(this.clientConfig);
        DatasetTypeMeta datasetTypeMeta = datasetTypeClient.get(Id.DatasetType.from((Id.Namespace)Id.Namespace.DEFAULT, (String)"someDatasetType"));
        datasetTypeMeta = datasetTypeClient.get(Id.DatasetType.from((Id.Namespace)Id.Namespace.DEFAULT, (String)SomeDataset.class.getName()));
    }

    public void queryClient() throws Exception {
        QueryClient queryClient = new QueryClient(this.clientConfig);
        ListenableFuture resultFuture = queryClient.execute(Id.Namespace.DEFAULT, "SELECT * FROM dataset_history WHERE customer IN ('Alice','Bob')");
        ExploreExecutionResult results = (ExploreExecutionResult)resultFuture.get();
        List schema = results.getResultSchema();
        String[] header = new String[schema.size()];
        for (int i = 0; i < header.length; ++i) {
            ColumnDesc column = (ColumnDesc)schema.get(i);
            int index = column.getPosition() - 1;
            header[index] = column.getName() + ": " + column.getType();
        }
    }

    public void serviceClient() throws Exception {
        ServiceClient serviceClient = new ServiceClient(this.clientConfig);
        ServiceSpecification serviceSpec = serviceClient.get(Id.Service.from((Id.Namespace)Id.Namespace.DEFAULT, (String)"PurchaseApp", (String)"CatalogLookup"));
    }

    public void metricsClient() throws Exception {
        MetricsClient metricsClient = new MetricsClient(this.clientConfig);
        RuntimeMetrics metric = metricsClient.getFlowletMetrics((Id.Program)Id.Flow.from((String)"user", (String)"HelloWorld", (String)"someFlow"), "process.events.processed");
    }

    public void monitorClient() throws Exception {
        MonitorClient monitorClient = new MonitorClient(this.clientConfig);
        List services = monitorClient.listSystemServices();
        String serviceStatus = monitorClient.getSystemServiceStatus("transaction");
        int systemServiceInstances = monitorClient.getSystemServiceInstances("transaction");
        monitorClient.setSystemServiceInstances("transaction", 1);
    }

    private File createAppJarFile(Class<?> cls) {
        return null;
    }

    private class SomeDataset {
        private SomeDataset() {
        }
    }

    private class SomeDatasetModule {
        private SomeDatasetModule() {
        }
    }
}

