/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.dq.functions;

import co.cask.cdap.api.common.Bytes;
import co.cask.cdap.dq.DataQualityWritable;
import co.cask.cdap.dq.functions.BasicAggregationFunction;
import co.cask.cdap.dq.functions.CombinableAggregationFunction;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class UniqueValues
implements BasicAggregationFunction,
CombinableAggregationFunction<Set<String>> {
    private static final Gson GSON = new Gson();
    private static final Type TOKEN_TYPE_SET_STRING = new TypeToken<Set<String>>(){}.getType();
    private Set<String> uniqueValuesSet = new HashSet<String>();
    private Set<String> aggregatedUniqueValuesSet = new HashSet<String>();

    @Override
    public Set<String> retrieveAggregation() {
        return this.aggregatedUniqueValuesSet.isEmpty() ? null : this.aggregatedUniqueValuesSet;
    }

    public Set<String> deserialize(byte[] valueBytes) {
        return (Set)GSON.fromJson(Bytes.toString((byte[])valueBytes), TOKEN_TYPE_SET_STRING);
    }

    @Override
    public void combine(byte[] value) {
        Object outputSet = this.deserialize(value);
        this.aggregatedUniqueValuesSet.addAll((Collection<String>)outputSet);
    }

    @Override
    public void add(DataQualityWritable value) {
        String val = value.get().toString();
        if (val != null) {
            this.uniqueValuesSet.add(val);
        }
    }

    @Override
    public byte[] aggregate() {
        return Bytes.toBytes((String)this.uniqueValuesSet.toString());
    }
}

