/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.dq.functions;

import co.cask.cdap.api.common.Bytes;
import co.cask.cdap.dq.DataQualityWritable;
import co.cask.cdap.dq.functions.BasicAggregationFunction;

public class StandardDeviation
implements BasicAggregationFunction {
    private Double sumOfValues = 0.0;
    private Double sumOfSquaresOfValues = 0.0;
    private Integer numberOfValues = 0;

    public Double deserialize(byte[] value) {
        return value == null ? null : Double.valueOf(Bytes.toDouble((byte[])value));
    }

    @Override
    public void add(DataQualityWritable value) {
        Double newVal = Double.parseDouble(value.get().toString());
        this.sumOfValues = this.sumOfValues + newVal;
        this.sumOfSquaresOfValues = this.sumOfSquaresOfValues + newVal * newVal;
        this.numberOfValues = this.numberOfValues + 1;
    }

    @Override
    public byte[] aggregate() {
        Double mean = this.sumOfValues / (double)this.numberOfValues.intValue();
        Double squareOfMean = Math.pow(mean, 2.0);
        Double meanOfSquares = this.sumOfSquaresOfValues / (double)this.numberOfValues.intValue();
        Double variance = meanOfSquares - squareOfMean;
        Double standardDeviation = Math.sqrt(variance);
        return Bytes.toBytes((double)standardDeviation);
    }
}

