/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.dq.functions;

import co.cask.cdap.api.common.Bytes;
import co.cask.cdap.dq.DataQualityWritable;
import co.cask.cdap.dq.functions.BasicAggregationFunction;

public class Mean
implements BasicAggregationFunction {
    private Double runningSum = 0.0;
    private Integer lengthValues = 0;

    public Double deserialize(byte[] value) {
        return value == null ? null : Double.valueOf(Bytes.toDouble((byte[])value));
    }

    @Override
    public void add(DataQualityWritable value) {
        this.runningSum = this.runningSum + Double.parseDouble(value.get().toString());
        this.lengthValues = this.lengthValues + 1;
    }

    @Override
    public byte[] aggregate() {
        return Bytes.toBytes((double)(this.runningSum / (double)this.lengthValues.intValue()));
    }
}

