/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.dq.functions;

import co.cask.cdap.api.common.Bytes;
import co.cask.cdap.dq.DataQualityWritable;
import co.cask.cdap.dq.functions.BasicAggregationFunction;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HistogramWithBucketing
implements BasicAggregationFunction<Map<Map.Entry<Double, Double>, Integer>> {
    private static final Gson GSON = new Gson();
    private static final Type TOKEN_TYPE_MAP_MAP_ENTRY_DOUBLE_DOUBLE_LONG = new TypeToken<Map<Map.Entry<Double, Double>, Long>>(){}.getType();
    private ArrayList<Double> values = new ArrayList();
    private Double max = Double.MIN_VALUE;
    private Double min = Double.MAX_VALUE;
    public Map<Map.Entry<Double, Double>, Long> histogram = new HashMap<Map.Entry<Double, Double>, Long>();

    @Override
    public void add(DataQualityWritable value) {
        Double newValue = Double.parseDouble(value.get().toString());
        this.max = newValue > this.max ? newValue : this.max;
        this.min = newValue < this.min ? newValue : this.min;
        this.values.add(newValue);
    }

    @Override
    public byte[] aggregate() {
        Bucketing bucketing = new Bucketing("automatic", null);
        bucketing.doBucketing();
        block0: for (Double value : this.values) {
            for (Map.Entry<Map.Entry<Double, Double>, Long> bucketMapEntry : this.histogram.entrySet()) {
                if (!(value >= bucketMapEntry.getKey().getKey()) || !(value <= bucketMapEntry.getKey().getValue())) continue;
                bucketMapEntry.setValue(bucketMapEntry.getValue() + 1L);
                continue block0;
            }
        }
        String aggregationJSON = GSON.toJson(this.histogram);
        return Bytes.toBytes((String)aggregationJSON);
    }

    @Override
    public Map<Map.Entry<Double, Double>, Integer> deserialize(byte[] serializedValue) {
        String valueJSON = Bytes.toString((byte[])serializedValue);
        return (Map)GSON.fromJson(valueJSON, TOKEN_TYPE_MAP_MAP_ENTRY_DOUBLE_DOUBLE_LONG);
    }

    private class Bucketing {
        String bucketingStrategy;
        Integer maxBucketSize;

        private Bucketing(String bucketingStrategy, Integer maxBucketSize) {
            this.maxBucketSize = maxBucketSize == null ? 10 : maxBucketSize;
            this.bucketingStrategy = bucketingStrategy;
        }

        private void doBucketing() {
            if ("automatic".equals(this.bucketingStrategy)) {
                this.automaticallyGenerateBuckets();
            } else if (this.maxBucketSize > 0) {
                this.manuallyGenerateBuckets(this.maxBucketSize.intValue());
            }
        }

        private void automaticallyGenerateBuckets() {
            Collections.sort(HistogramWithBucketing.this.values);
            long valuesListSize = HistogramWithBucketing.this.values.size();
            long quartile = (long)Math.floor((double)valuesListSize / 4.0);
            Double firstQuartile = (Double)HistogramWithBucketing.this.values.get((int)quartile);
            Double thirdQuartile = (Double)HistogramWithBucketing.this.values.get((int)quartile * 3);
            Double interquartileRange = thirdQuartile - firstQuartile;
            Long maxBucketSize = (long)Math.ceil(2.0 * interquartileRange * Math.pow(valuesListSize, 0.0));
            if (maxBucketSize == 0L) {
                maxBucketSize = 1L;
            }
            for (double i = HistogramWithBucketing.this.min.doubleValue(); i < HistogramWithBucketing.this.max; i += (double)maxBucketSize.longValue()) {
                AbstractMap.SimpleEntry<Double, Double> mapEntry = new AbstractMap.SimpleEntry<Double, Double>(i, i + (double)maxBucketSize.longValue());
                HistogramWithBucketing.this.histogram.put(mapEntry, 0L);
            }
        }

        private void manuallyGenerateBuckets(long maxBucketSize) {
            Collections.sort(HistogramWithBucketing.this.values);
            for (double i = HistogramWithBucketing.this.min.doubleValue(); i < HistogramWithBucketing.this.max; i += (double)maxBucketSize) {
                AbstractMap.SimpleEntry<Double, Double> mapEntry = new AbstractMap.SimpleEntry<Double, Double>(i, i + (double)maxBucketSize);
                HistogramWithBucketing.this.histogram.put(mapEntry, 0L);
            }
        }
    }
}

