/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.dq.functions;

import co.cask.cdap.api.common.Bytes;
import co.cask.cdap.dq.DataQualityWritable;
import co.cask.cdap.dq.functions.BasicAggregationFunction;
import co.cask.cdap.dq.functions.CombinableAggregationFunction;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class DiscreteValuesHistogram
implements BasicAggregationFunction,
CombinableAggregationFunction<Map<String, Integer>> {
    private static final Gson GSON = new Gson();
    private static final Type TOKEN_TYPE_MAP_STRING_INTEGER = new TypeToken<Map<String, Integer>>(){}.getType();
    private Map<String, Integer> histogramMap = new HashMap<String, Integer>();
    private Map<String, Integer> aggregatedHistogramMap = new HashMap<String, Integer>();

    @Override
    public void combine(byte[] value) {
        Object outputMap = this.deserialize(value);
        for (Map.Entry entry : outputMap.entrySet()) {
            Integer val = this.aggregatedHistogramMap.get(entry.getKey());
            this.aggregatedHistogramMap.put((String)entry.getKey(), val == null ? (Integer)entry.getValue() : val + (Integer)entry.getValue());
        }
    }

    public Map<String, Integer> deserialize(byte[] valueBytes) {
        return (Map)GSON.fromJson(Bytes.toString((byte[])valueBytes), TOKEN_TYPE_MAP_STRING_INTEGER);
    }

    @Override
    public Map<String, Integer> retrieveAggregation() {
        return this.aggregatedHistogramMap.isEmpty() ? null : this.aggregatedHistogramMap;
    }

    @Override
    public void add(DataQualityWritable value) {
        Integer mapVal = this.histogramMap.get(value.get().toString());
        if (mapVal != null) {
            this.histogramMap.put(value.get().toString(), mapVal + 1);
        } else {
            this.histogramMap.put(value.get().toString(), 1);
        }
    }

    @Override
    public byte[] aggregate() {
        return Bytes.toBytes((String)GSON.toJson(this.histogramMap));
    }
}

