/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.dq;

import co.cask.cdap.api.data.stream.Stream;
import co.cask.cdap.api.dataset.Dataset;
import co.cask.cdap.api.dataset.DatasetProperties;
import co.cask.cdap.api.dataset.module.DatasetModule;
import co.cask.cdap.api.mapreduce.MapReduceConfigurer;
import co.cask.cdap.api.plugin.PluginProperties;
import co.cask.cdap.api.plugin.PluginSelector;
import co.cask.cdap.etl.api.PipelineConfigurer;
import javax.annotation.Nullable;

public class MapReducePipelineConfigurer
implements PipelineConfigurer {
    private final MapReduceConfigurer mrConfigurer;
    private final String prefixId;

    public MapReducePipelineConfigurer(MapReduceConfigurer configurer, String prefixId) {
        this.mrConfigurer = configurer;
        this.prefixId = prefixId;
    }

    public void addStream(Stream stream) {
        this.mrConfigurer.addStream(stream);
    }

    public void addStream(String streamName) {
        this.mrConfigurer.addStream(streamName);
    }

    public void addDatasetModule(String moduleName, Class<? extends DatasetModule> moduleClass) {
        this.mrConfigurer.addDatasetModule(moduleName, moduleClass);
    }

    public void addDatasetType(Class<? extends Dataset> datasetClass) {
        this.mrConfigurer.addDatasetType(datasetClass);
    }

    public void createDataset(String datasetName, String typeName, DatasetProperties properties) {
        this.mrConfigurer.createDataset(datasetName, typeName, properties);
    }

    public void createDataset(String datasetName, String typeName) {
        this.mrConfigurer.createDataset(datasetName, typeName);
    }

    public void createDataset(String datasetName, Class<? extends Dataset> datasetClass, DatasetProperties props) {
        this.mrConfigurer.createDataset(datasetName, datasetClass, props);
    }

    public void createDataset(String datasetName, Class<? extends Dataset> datasetClass) {
        this.mrConfigurer.createDataset(datasetName, datasetClass);
    }

    @Nullable
    public <T> T usePlugin(String pluginType, String pluginName, String pluginId, PluginProperties properties) {
        return (T)this.mrConfigurer.usePlugin(pluginType, pluginName, this.prefixId + pluginId, properties);
    }

    @Nullable
    public <T> T usePlugin(String pluginType, String pluginName, String pluginId, PluginProperties properties, PluginSelector selector) {
        return (T)this.mrConfigurer.usePlugin(pluginType, pluginName, this.prefixId + pluginId, properties, selector);
    }

    @Nullable
    public <T> Class<T> usePluginClass(String pluginType, String pluginName, String pluginId, PluginProperties properties) {
        return this.mrConfigurer.usePluginClass(pluginType, pluginName, this.prefixId + pluginId, properties);
    }

    @Nullable
    public <T> Class<T> usePluginClass(String pluginType, String pluginName, String pluginId, PluginProperties properties, PluginSelector selector) {
        return this.mrConfigurer.usePluginClass(pluginType, pluginName, this.prefixId + pluginId, properties, selector);
    }
}

