/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.io;

import co.cask.cdap.api.data.schema.Schema;
import co.cask.cdap.api.data.schema.UnsupportedTypeException;
import co.cask.cdap.internal.io.ReflectionSchemaGenerator;
import co.cask.cdap.internal.io.SchemaTypeAdapter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.IntNode;
import org.codehaus.jackson.node.TextNode;
import org.junit.Assert;
import org.junit.Test;

public class SchemaTest {
    @Test
    public void testGenerateSchema() throws UnsupportedTypeException {
        co.cask.cdap.api.data.schema.Schema schema = new ReflectionSchemaGenerator().generate(new TypeToken<Child<Node>>(){}.getType());
        Gson gson = new GsonBuilder().registerTypeAdapter(co.cask.cdap.api.data.schema.Schema.class, (Object)new SchemaTypeAdapter()).create();
        Assert.assertEquals((Object)schema, (Object)gson.fromJson(gson.toJson((Object)schema), co.cask.cdap.api.data.schema.Schema.class));
    }

    @Test
    public void testSchemaHash() throws UnsupportedTypeException {
        co.cask.cdap.api.data.schema.Schema s1 = new ReflectionSchemaGenerator().generate(Node.class);
        co.cask.cdap.api.data.schema.Schema s2 = new ReflectionSchemaGenerator().generate(Node2.class);
        Assert.assertEquals((Object)s1.getSchemaHash(), (Object)s2.getSchemaHash());
        Assert.assertEquals((Object)s1, (Object)s2);
        co.cask.cdap.api.data.schema.Schema schema = new ReflectionSchemaGenerator().generate(new TypeToken<Child<Node>>(){}.getType());
        Assert.assertNotEquals((Object)s1.getSchemaHash(), (Object)schema.getSchemaHash());
    }

    @Test
    public void testAvroEnumSchema() throws Exception {
        Schema schema = Schema.createEnum((String)"UserInterests", (String)"Describes interests of user", (String)"org.example.schema", (List)ImmutableList.of((Object)"CRICKET", (Object)"BASEBALL"));
        co.cask.cdap.api.data.schema.Schema parsedSchema = co.cask.cdap.api.data.schema.Schema.parseJson((String)schema.toString());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"CRICKET", (Object)"BASEBALL"), (Object)parsedSchema.getEnumValues());
    }

    @Test
    public void testAvroRecordSchema() throws Exception {
        Schema avroStringSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        Schema avroIntSchema = Schema.create((Schema.Type)Schema.Type.INT);
        Schema schema = Schema.createRecord((String)"UserInfo", (String)"Describes user information", (String)"org.example.schema", (boolean)false);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        Schema.Field field = new Schema.Field("username", avroStringSchema, "Field represents username", (JsonNode)new TextNode("unknown"));
        fields.add(field);
        field = new Schema.Field("age", avroIntSchema, "Field represents age of user", (JsonNode)new IntNode(-1));
        fields.add(field);
        schema.setFields(fields);
        co.cask.cdap.api.data.schema.Schema parsedSchema = co.cask.cdap.api.data.schema.Schema.parseJson((String)schema.toString());
        Assert.assertTrue((boolean)"UserInfo".equals(parsedSchema.getRecordName()));
        Assert.assertEquals((long)2L, (long)parsedSchema.getFields().size());
        Schema.Field parsedField = (Schema.Field)parsedSchema.getFields().get(0);
        Assert.assertTrue((boolean)"username".equals(parsedField.getName()));
        Assert.assertTrue((boolean)"STRING".equals(parsedField.getSchema().getType().toString()));
        parsedField = (Schema.Field)parsedSchema.getFields().get(1);
        Assert.assertTrue((boolean)"age".equals(parsedField.getName()));
        Assert.assertTrue((boolean)"INT".equals(parsedField.getSchema().getType().toString()));
    }

    @Test
    public void testCompatible() throws UnsupportedTypeException {
        co.cask.cdap.api.data.schema.Schema s1 = new ReflectionSchemaGenerator().generate(Node.class);
        co.cask.cdap.api.data.schema.Schema s2 = new ReflectionSchemaGenerator().generate(Node3.class);
        co.cask.cdap.api.data.schema.Schema s3 = new ReflectionSchemaGenerator().generate(Node4.class);
        Assert.assertNotEquals((Object)s1, (Object)s2);
        Assert.assertTrue((boolean)s1.isCompatible(s2));
        Assert.assertFalse((boolean)s2.isCompatible(s1));
        Assert.assertTrue((boolean)s2.isCompatible(s3));
    }

    @Test
    public void testPrimitiveArray() throws UnsupportedTypeException {
        co.cask.cdap.api.data.schema.Schema schema = new ReflectionSchemaGenerator().generate(int[].class);
        Assert.assertEquals((Object)co.cask.cdap.api.data.schema.Schema.arrayOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.INT)), (Object)schema);
    }

    @Test
    public void testParseJson() throws IOException, UnsupportedTypeException {
        co.cask.cdap.api.data.schema.Schema schema = new ReflectionSchemaGenerator().generate(Node.class);
        Assert.assertEquals((Object)schema, (Object)co.cask.cdap.api.data.schema.Schema.parseJson((String)schema.toString()));
    }

    @Test
    public void testSameRecordDifferentLevels() throws UnsupportedTypeException, IOException {
        co.cask.cdap.api.data.schema.Schema actual = new ReflectionSchemaGenerator().generate(Node6.class);
        Assert.assertEquals((Object)Node6.SCHEMA, (Object)actual);
        Assert.assertEquals((Object)Node6.SCHEMA, (Object)co.cask.cdap.api.data.schema.Schema.parseJson((String)actual.toString()));
    }

    @Test
    public void testParseFlatSQL() throws IOException {
        String schemaStr = "bool_field boolean, int_field int not null, long_field long not null, float_field float NOT NULL, double_field double NOT NULL, bytes_field bytes not null, array_field array<string> not null, map_field map<string,int> not null, record_field record<x:int,y:double>, string_field string";
        co.cask.cdap.api.data.schema.Schema expected = co.cask.cdap.api.data.schema.Schema.recordOf((String)"rec", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"bool_field", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.nullableOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.BOOLEAN))), Schema.Field.of((String)"int_field", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.INT)), Schema.Field.of((String)"long_field", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.LONG)), Schema.Field.of((String)"float_field", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.FLOAT)), Schema.Field.of((String)"double_field", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.DOUBLE)), Schema.Field.of((String)"bytes_field", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.BYTES)), Schema.Field.of((String)"array_field", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.arrayOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.nullableOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.STRING)))), Schema.Field.of((String)"map_field", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.mapOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.nullableOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.STRING)), (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.nullableOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.INT)))), Schema.Field.of((String)"record_field", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.nullableOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.recordOf((String)"rec1", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"x", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.nullableOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.INT))), Schema.Field.of((String)"y", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.nullableOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.DOUBLE)))}))), Schema.Field.of((String)"string_field", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.nullableOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.STRING)))});
        Assert.assertEquals((Object)expected, (Object)co.cask.cdap.api.data.schema.Schema.parseSQL((String)schemaStr));
    }

    @Test
    public void testNestedSQL() throws IOException {
        co.cask.cdap.api.data.schema.Schema expected = co.cask.cdap.api.data.schema.Schema.recordOf((String)"rec", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"x", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.mapOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.recordOf((String)"rec1", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"x", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.STRING)), Schema.Field.of((String)"y", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.arrayOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.STRING))), Schema.Field.of((String)"z", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.mapOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.BYTES), (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.DOUBLE)))}), (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.arrayOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.recordOf((String)"rec2", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"x", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.mapOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.arrayOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.BYTES)), (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.mapOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.BOOLEAN), (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.BYTES))))})))), Schema.Field.of((String)"y", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.INT))});
        String schemaStr = "x map<record<x:string not null,y:array<string not null> not null,z:map<bytes not null,double not null> not null> not null,array<record<x:map<array<bytes not null> not null,map<boolean not null,bytes not null> not null> not null> not null> not null> not null, y int not null";
        Assert.assertEquals((Object)expected, (Object)co.cask.cdap.api.data.schema.Schema.parseSQL((String)schemaStr));
    }

    @Test
    public void testParseSQLWithWhitespace() throws IOException {
        String schemaStr = "map_field map< string , int >   not null,\narr_field array< record< x:int , y:double >\t> not null";
        co.cask.cdap.api.data.schema.Schema expectedSchema = co.cask.cdap.api.data.schema.Schema.recordOf((String)"rec", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"map_field", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.mapOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.nullableOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.STRING)), (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.nullableOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.INT)))), Schema.Field.of((String)"arr_field", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.arrayOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.nullableOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.recordOf((String)"rec1", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"x", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.nullableOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.INT))), Schema.Field.of((String)"y", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.nullableOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.DOUBLE)))}))))});
        Assert.assertEquals((Object)expectedSchema, (Object)co.cask.cdap.api.data.schema.Schema.parseSQL((String)schemaStr));
    }

    @Test
    public void testInvalidSQL() {
        this.verifyThrowsException("int x");
        this.verifyThrowsException("x map<int, int");
        this.verifyThrowsException("x array<string");
        this.verifyThrowsException("x bool");
        this.verifyThrowsException("x integer");
        this.verifyThrowsException("x record<y int>");
        this.verifyThrowsException("x array<>");
    }

    @Test
    public void testSerializable() throws IOException, ClassNotFoundException {
        co.cask.cdap.api.data.schema.Schema schema = co.cask.cdap.api.data.schema.Schema.recordOf((String)"record", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"boolean", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.BOOLEAN)), Schema.Field.of((String)"int", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.INT)), Schema.Field.of((String)"long", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.LONG)), Schema.Field.of((String)"float", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.FLOAT)), Schema.Field.of((String)"double", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.DOUBLE)), Schema.Field.of((String)"string", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.STRING)), Schema.Field.of((String)"bytes", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.BYTES)), Schema.Field.of((String)"enum", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.enumWith((String[])new String[]{"a", "b", "c"})), Schema.Field.of((String)"array", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.arrayOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.INT))), Schema.Field.of((String)"map", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.mapOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.STRING), (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.INT))), Schema.Field.of((String)"union", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.unionOf((co.cask.cdap.api.data.schema.Schema[])new co.cask.cdap.api.data.schema.Schema[]{co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.NULL), co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.STRING)}))});
        String schemaString = schema.toString();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(os);){
            oos.writeObject(schema);
        }
        var5_5 = null;
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(os.toByteArray()));){
            co.cask.cdap.api.data.schema.Schema restoredSchema = (co.cask.cdap.api.data.schema.Schema)ois.readObject();
            Assert.assertEquals((Object)schema, (Object)restoredSchema);
            Assert.assertEquals((Object)schemaString, (Object)restoredSchema.toString());
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    private void verifyThrowsException(String toParse) {
        try {
            co.cask.cdap.api.data.schema.Schema.parseSQL((String)toParse);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final class Node6 {
        private static final co.cask.cdap.api.data.schema.Schema SCHEMA = co.cask.cdap.api.data.schema.Schema.recordOf((String)Node6.class.getName(), (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"x", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.nullableOf((co.cask.cdap.api.data.schema.Schema)Node4.access$000())), Schema.Field.of((String)"y", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.nullableOf((co.cask.cdap.api.data.schema.Schema)Node5.access$100()))});
        private Node4 x;
        private Node5 y;
    }

    public static final class Node5 {
        private static final co.cask.cdap.api.data.schema.Schema SCHEMA = co.cask.cdap.api.data.schema.Schema.recordOf((String)Node5.class.getName(), (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"x", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.nullableOf((co.cask.cdap.api.data.schema.Schema)Node4.access$000()))});
        private Node4 x;

        static /* synthetic */ co.cask.cdap.api.data.schema.Schema access$100() {
            return SCHEMA;
        }
    }

    public static final class Node4 {
        private static final co.cask.cdap.api.data.schema.Schema SCHEMA = co.cask.cdap.api.data.schema.Schema.recordOf((String)Node4.class.getName(), (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"data", (co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.nullableOf((co.cask.cdap.api.data.schema.Schema)co.cask.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.STRING)))});
        private String data;

        static /* synthetic */ co.cask.cdap.api.data.schema.Schema access$000() {
            return SCHEMA;
        }
    }

    public final class Node3 {
        private long data;
        private String tag;
        private List<Node3> children;
    }

    public final class Node2 {
        private int data;
        private List<Node2> children;
    }

    public static enum State {
        OK,
        ERROR;

    }

    public class Child<T>
    extends Parent<Map<String, T>> {
        private int height;
        private Node rootNode;
        private State state;
    }

    public class Parent<T> {
        private T data;
        private ByteBuffer buffer;
    }

    public final class Node {
        private int data;
        private List<Node> children;
    }
}

