/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.io;

import co.cask.cdap.api.data.schema.Schema;
import co.cask.cdap.api.data.schema.UnsupportedTypeException;
import co.cask.cdap.api.flow.flowlet.StreamEvent;
import co.cask.cdap.common.io.BinaryDecoder;
import co.cask.cdap.common.io.BinaryEncoder;
import co.cask.cdap.common.io.Encoder;
import co.cask.cdap.internal.io.ASMDatumWriterFactory;
import co.cask.cdap.internal.io.ASMFieldAccessorFactory;
import co.cask.cdap.internal.io.DatumWriter;
import co.cask.cdap.internal.io.FieldAccessorFactory;
import co.cask.cdap.internal.io.ReflectionDatumReader;
import co.cask.cdap.internal.io.ReflectionDatumWriter;
import co.cask.cdap.internal.io.ReflectionSchemaGenerator;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ASMDatumCodecTest {
    private static final ASMDatumWriterFactory DATUM_WRITER_FACTORY = new ASMDatumWriterFactory((FieldAccessorFactory)new ASMFieldAccessorFactory());

    private <T> Schema getSchema(TypeToken<T> type) throws UnsupportedTypeException {
        return new ReflectionSchemaGenerator().generate(type.getType());
    }

    private <T> DatumWriter<T> getWriter(TypeToken<T> type) throws UnsupportedTypeException {
        Schema schema = this.getSchema(type);
        return DATUM_WRITER_FACTORY.create(type, schema);
    }

    @Test
    public void testShort() throws UnsupportedTypeException, IOException {
        TypeToken<Short> type = new TypeToken<Short>(){};
        PipedOutputStream os = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(os);
        DatumWriter<Short> writer = this.getWriter(type);
        writer.encode((Object)3000, (Encoder)new BinaryEncoder((OutputStream)os));
        ReflectionDatumReader reader = new ReflectionDatumReader(this.getSchema(type), (TypeToken)type);
        short value = (Short)reader.read((Object)new BinaryDecoder((InputStream)is), this.getSchema(type));
        Assert.assertEquals((long)3000L, (long)value);
    }

    @Test
    public void testInt() throws UnsupportedTypeException, IOException {
        TypeToken<Integer> type = new TypeToken<Integer>(){};
        PipedOutputStream os = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(os);
        DatumWriter<Integer> writer = this.getWriter(type);
        writer.encode((Object)12234234, (Encoder)new BinaryEncoder((OutputStream)os));
        ReflectionDatumReader reader = new ReflectionDatumReader(this.getSchema(type), (TypeToken)type);
        int value = (Integer)reader.read((Object)new BinaryDecoder((InputStream)is), this.getSchema(type));
        Assert.assertEquals((long)12234234L, (long)value);
    }

    @Test
    public void testDouble() throws UnsupportedTypeException, IOException {
        TypeToken<Double> type = new TypeToken<Double>(){};
        PipedOutputStream os = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(os);
        DatumWriter<Double> writer = this.getWriter(type);
        writer.encode((Object)3.14, (Encoder)new BinaryEncoder((OutputStream)os));
        ReflectionDatumReader reader = new ReflectionDatumReader(this.getSchema(type), (TypeToken)type);
        double value = (Double)reader.read((Object)new BinaryDecoder((InputStream)is), this.getSchema(type));
        Assert.assertEquals((double)3.14, (double)value, (double)1.0E-6);
    }

    @Test
    public void testString() throws UnsupportedTypeException, IOException {
        TypeToken<String> type = new TypeToken<String>(){};
        PipedOutputStream os = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(os);
        DatumWriter<String> writer = this.getWriter(type);
        writer.encode((Object)"Testing message", (Encoder)new BinaryEncoder((OutputStream)os));
        ReflectionDatumReader reader = new ReflectionDatumReader(this.getSchema(type), (TypeToken)type);
        String value = (String)reader.read((Object)new BinaryDecoder((InputStream)is), this.getSchema(type));
        Assert.assertEquals((Object)"Testing message", (Object)value);
    }

    @Test
    public void testUUID() throws UnsupportedTypeException, IOException {
        TypeToken<UUID> type = new TypeToken<UUID>(){};
        PipedOutputStream os = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(os);
        DatumWriter<UUID> writer = this.getWriter(type);
        UUID uuid = UUID.randomUUID();
        writer.encode((Object)uuid, (Encoder)new BinaryEncoder((OutputStream)os));
        ReflectionDatumReader reader = new ReflectionDatumReader(this.getSchema(type), (TypeToken)type);
        UUID value = (UUID)reader.read((Object)new BinaryDecoder((InputStream)is), this.getSchema(type));
        Assert.assertEquals((Object)uuid, (Object)value);
    }

    @Test
    public void testEnum() throws UnsupportedTypeException, IOException {
        TypeToken<TestEnum> type = new TypeToken<TestEnum>(){};
        PipedOutputStream os = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(os);
        DatumWriter<TestEnum> writer = this.getWriter(type);
        BinaryEncoder encoder = new BinaryEncoder((OutputStream)os);
        writer.encode((Object)TestEnum.VALUE1, (Encoder)encoder);
        writer.encode((Object)TestEnum.VALUE4, (Encoder)encoder);
        writer.encode((Object)TestEnum.VALUE3, (Encoder)encoder);
        ReflectionDatumReader reader = new ReflectionDatumReader(this.getSchema(type), (TypeToken)type);
        TestEnum value = (TestEnum)((Object)reader.read((Object)new BinaryDecoder((InputStream)is), this.getSchema(type)));
        Assert.assertEquals((Object)((Object)TestEnum.VALUE1), (Object)((Object)value));
        value = (TestEnum)((Object)reader.read((Object)new BinaryDecoder((InputStream)is), this.getSchema(type)));
        Assert.assertEquals((Object)((Object)TestEnum.VALUE4), (Object)((Object)value));
        value = (TestEnum)((Object)reader.read((Object)new BinaryDecoder((InputStream)is), this.getSchema(type)));
        Assert.assertEquals((Object)((Object)TestEnum.VALUE3), (Object)((Object)value));
    }

    @Test
    public void testPrimitiveArray() throws IOException, UnsupportedTypeException {
        TypeToken<int[]> type = new TypeToken<int[]>(){};
        PipedOutputStream os = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(os);
        int[] writeValue = new int[]{1, 2, 3, 4, -5, -6, -7, -8};
        DatumWriter<int[]> writer = this.getWriter(type);
        writer.encode((Object)writeValue, (Encoder)new BinaryEncoder((OutputStream)os));
        ReflectionDatumReader reader = new ReflectionDatumReader(this.getSchema(type), (TypeToken)type);
        int[] value = (int[])reader.read((Object)new BinaryDecoder((InputStream)is), this.getSchema(type));
        Assert.assertArrayEquals((int[])writeValue, (int[])value);
    }

    @Test
    public void testReferenceArray() throws IOException, UnsupportedTypeException {
        TypeToken<String[]> type = new TypeToken<String[]>(){};
        PipedOutputStream os = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(os);
        Object[] writeValue = new String[]{"1", "2", null, "3"};
        DatumWriter<String[]> writer = this.getWriter(type);
        writer.encode((Object)writeValue, (Encoder)new BinaryEncoder((OutputStream)os));
        ReflectionDatumReader reader = new ReflectionDatumReader(this.getSchema(type), (TypeToken)type);
        Object[] value = (String[])reader.read((Object)new BinaryDecoder((InputStream)is), this.getSchema(type));
        Assert.assertArrayEquals((Object[])writeValue, (Object[])value);
    }

    @Test
    public void testList() throws IOException, UnsupportedTypeException {
        TypeToken<List<Long>> type = new TypeToken<List<Long>>(){};
        PipedOutputStream os = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(os);
        ImmutableList writeValue = ImmutableList.of((Object)1L, (Object)10L, (Object)100L, (Object)1000L);
        DatumWriter<List<Long>> writer = this.getWriter(type);
        writer.encode((Object)writeValue, (Encoder)new BinaryEncoder((OutputStream)os));
        ReflectionDatumReader reader = new ReflectionDatumReader(this.getSchema(type), (TypeToken)type);
        List value = (List)reader.read((Object)new BinaryDecoder((InputStream)is), this.getSchema(type));
        Assert.assertEquals((Object)writeValue, (Object)value);
    }

    @Test
    public void testMap() throws IOException, UnsupportedTypeException {
        TypeToken<Map<String, List<String>>> type = new TypeToken<Map<String, List<String>>>(){};
        PipedOutputStream os = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(os);
        DatumWriter<Map<String, List<String>>> writer = this.getWriter(type);
        ImmutableMap map = ImmutableMap.of((Object)"k1", (Object)Lists.newArrayList((Object[])new String[]{"v1"}), (Object)"k2", (Object)Lists.newArrayList((Object[])new String[]{"v2", null}));
        writer.encode((Object)map, (Encoder)new BinaryEncoder((OutputStream)os));
        ReflectionDatumReader reader = new ReflectionDatumReader(this.getSchema(type), (TypeToken)type);
        Assert.assertEquals((Object)map, (Object)reader.read((Object)new BinaryDecoder((InputStream)is), this.getSchema(type)));
    }

    @Test
    public void testURI() throws IOException, UnsupportedTypeException {
        TypeToken<List<URI>> type = new TypeToken<List<URI>>(){};
        PipedOutputStream os = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(os);
        DatumWriter<List<URI>> writer = this.getWriter(type);
        ImmutableList writeValue = ImmutableList.of((Object)URI.create("http://www.abc.com"));
        writer.encode((Object)writeValue, (Encoder)new BinaryEncoder((OutputStream)os));
        ReflectionDatumReader reader = new ReflectionDatumReader(this.getSchema(type), (TypeToken)type);
        Assert.assertEquals((Object)writeValue, (Object)reader.read((Object)new BinaryDecoder((InputStream)is), this.getSchema(type)));
    }

    @Test
    public void testRecord() throws IOException, UnsupportedTypeException {
        TypeToken<Record> type = new TypeToken<Record>(){};
        PipedOutputStream os = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(os);
        DatumWriter<Record> writer = this.getWriter(type);
        Record writeValue = new Record(10, "testing", (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), TestEnum.VALUE2);
        writer.encode((Object)writeValue, (Encoder)new BinaryEncoder((OutputStream)os));
        ReflectionDatumReader reader = new ReflectionDatumReader(this.getSchema(type), (TypeToken)type);
        Record value = (Record)reader.read((Object)new BinaryDecoder((InputStream)is), this.getSchema(type));
        Assert.assertEquals((Object)writeValue, (Object)value);
    }

    @Test
    public void testRecordContainer() throws IOException, UnsupportedTypeException {
        TypeToken<List<Record>> type = new TypeToken<List<Record>>(){};
        PipedOutputStream os = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(os);
        DatumWriter<List<Record>> writer = this.getWriter(type);
        ImmutableList writeValue = ImmutableList.of((Object)new Record(10, "testing", (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), TestEnum.VALUE2));
        writer.encode((Object)writeValue, (Encoder)new BinaryEncoder((OutputStream)os));
        ReflectionDatumReader reader = new ReflectionDatumReader(this.getSchema(type), (TypeToken)type);
        List value = (List)reader.read((Object)new BinaryDecoder((InputStream)is), this.getSchema(type));
        Assert.assertEquals((Object)writeValue, (Object)value);
    }

    @Test
    public void testRecordArray() throws IOException, UnsupportedTypeException {
        TypeToken<Record[][]> type = new TypeToken<Record[][]>(){};
        PipedOutputStream os = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(os);
        DatumWriter<Record[][]> writer = this.getWriter(type);
        Record[][] writeValue = new Record[][]{{new Record(10, "testing", (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), TestEnum.VALUE2)}};
        writer.encode((Object)writeValue, (Encoder)new BinaryEncoder((OutputStream)os));
        ReflectionDatumReader reader = new ReflectionDatumReader(this.getSchema(type), (TypeToken)type);
        Record[][] value = (Record[][])reader.read((Object)new BinaryDecoder((InputStream)is), this.getSchema(type));
        Assert.assertArrayEquals((Object[])writeValue, (Object[])value);
    }

    @Test
    public void testTree() throws IOException, UnsupportedTypeException {
        TypeToken<Node> type = new TypeToken<Node>(){};
        PipedOutputStream os = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(os);
        DatumWriter<Node> writer = this.getWriter(type);
        Node root = new Node(1, new Node(2, null, new Node(3, null, null)), new Node(4, new Node(5, null, null), null));
        writer.encode((Object)root, (Encoder)new BinaryEncoder((OutputStream)os));
        ReflectionDatumReader reader = new ReflectionDatumReader(this.getSchema(type), (TypeToken)type);
        Node value = (Node)reader.read((Object)new BinaryDecoder((InputStream)is), this.getSchema(type));
        Assert.assertEquals((Object)root, (Object)value);
    }

    @Test
    public void testStreamEvent() throws IOException, UnsupportedTypeException {
        TypeToken<StreamEvent> type = new TypeToken<StreamEvent>(){};
        PipedOutputStream os = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(os);
        DatumWriter<StreamEvent> writer = this.getWriter(type);
        StreamEvent event = new StreamEvent((Map)ImmutableMap.of((Object)"key", (Object)"value"), ByteBuffer.wrap("Testing message".getBytes(Charsets.UTF_8)));
        writer.encode((Object)event, (Encoder)new BinaryEncoder((OutputStream)os));
        ReflectionDatumReader reader = new ReflectionDatumReader(this.getSchema(type), (TypeToken)type);
        StreamEvent value = (StreamEvent)reader.read((Object)new BinaryDecoder((InputStream)is), this.getSchema(type));
        Assert.assertEquals((Object)event.getHeaders(), (Object)value.getHeaders());
        Assert.assertEquals((Object)event.getBody(), (Object)value.getBody());
    }

    @Ignore
    @Test
    public void testSpeed() throws UnsupportedTypeException, IOException {
        int i;
        TypeToken<Node> type = new TypeToken<Node>(){};
        ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
        Node writeValue = new Node(1, new Node(2, null, new Node(3, null, null)), new Node(4, new Node(5, null, null), null));
        DatumWriter<Node> writer = this.getWriter(type);
        long startTime = System.nanoTime();
        for (int i2 = 0; i2 < 100000; ++i2) {
            os.reset();
            writer.encode((Object)writeValue, (Encoder)new BinaryEncoder((OutputStream)os));
        }
        long endTime = System.nanoTime();
        System.out.println("Time spent: " + TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS));
        ReflectionDatumWriter datumWriter = new ReflectionDatumWriter(this.getSchema(type));
        startTime = System.nanoTime();
        for (i = 0; i < 100000; ++i) {
            os.reset();
            datumWriter.encode((Object)writeValue, (Encoder)new BinaryEncoder((OutputStream)os));
        }
        endTime = System.nanoTime();
        System.out.println("Time spent: " + TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS));
        writer = this.getWriter(type);
        startTime = System.nanoTime();
        for (i = 0; i < 100000; ++i) {
            os.reset();
            writer.encode((Object)writeValue, (Encoder)new BinaryEncoder((OutputStream)os));
        }
        endTime = System.nanoTime();
        System.out.println("Time spent: " + TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS));
        datumWriter = new ReflectionDatumWriter(this.getSchema(type));
        startTime = System.nanoTime();
        for (i = 0; i < 100000; ++i) {
            os.reset();
            datumWriter.encode((Object)writeValue, (Encoder)new BinaryEncoder((OutputStream)os));
        }
        endTime = System.nanoTime();
        System.out.println("Time spent: " + TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS));
    }

    public static final class Node {
        public short data;
        public Short boxedData;
        public Node left;
        public Node right;

        public Node(short data, Node left, Node right) {
            this.data = data;
            this.boxedData = data;
            this.left = left;
            this.right = right;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.data == node.data && (this.left != null ? this.left.equals(node.left) : node.left == null) && (this.right != null ? this.right.equals(node.right) : node.right == null);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.data, this.left, this.right});
        }
    }

    private static class Record {
        private int i;
        private String s;
        private List<String> list;
        private TestEnum e;

        Record(int i, String s, List<String> list, TestEnum e) {
            this.i = i;
            this.s = s;
            this.list = list;
            this.e = e;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Record record = (Record)o;
            return this.i == record.i && this.e == record.e && this.list.equals(record.list) && this.s.equals(record.s);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.i, this.s, this.list, this.e});
        }
    }

    public static enum TestEnum {
        VALUE1,
        VALUE2,
        VALUE3,
        VALUE4;

    }
}

